package mc.recraftors.unruled_api.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import mc.recraftors.unruled_api.rules.OverridesManager;
import mc.recraftors.unruled_api.utils.*;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.GameRuleCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import static net.minecraft.commands.Commands.literal;

@Mixin(GameRuleCommand.class)
public abstract class GameRuleCommandMixin {
    @Inject(method = "register",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/world/GameRules;accept(Lnet/minecraft/world/GameRules$Visitor;)V"
            ))
    private static void setupOverridesCommand(
            CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandRegistryAccess, CallbackInfo ci,
            @Local(ordinal = 0) LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder,
            @Share("gamerule-overrides") LocalRef<LiteralArgumentBuilder<CommandSourceStack>> ref
    ) {
		LiteralArgumentBuilder<CommandSourceStack> builder = literal("gamerule-override")
			.requires(source -> source.hasPermission(2));
        ref.set(builder);
        Utils.aggregatorsMap.set(new HashMap<>());
        builder.executes(GameRuleCommandMixin::unruled_listOverridesSimple);
        builder.then(Commands.argument("dimension", DimensionArgument.dimension())
                .executes(GameRuleCommandMixin::unruled_listOverridesInWorld));
    }

    @WrapOperation(method = "register",
            at = @At(value = "INVOKE",
                    target = "Lcom/mojang/brigadier/CommandDispatcher;register(Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;)Lcom/mojang/brigadier/tree/LiteralCommandNode;"
            ))
    private static LiteralCommandNode<CommandSourceStack> finallizeOverridesCommand(
            CommandDispatcher<CommandSourceStack> dispatcher,
            LiteralArgumentBuilder<CommandSourceStack> command,
            Operation<LiteralCommandNode<CommandSourceStack>> original,
            @Local(ordinal = 0) LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder,
            @Share("gamerule-overrides") LocalRef<LiteralArgumentBuilder<CommandSourceStack>> ref
    ) {
        LiteralArgumentBuilder<CommandSourceStack> builder = ref.get();
        Map<String, CommandAggregator> map = Utils.aggregatorsMap.get();
        LiteralArgumentBuilder<CommandSourceStack> get = literal("get");
        LiteralArgumentBuilder<CommandSourceStack> set = literal("set");
        LiteralArgumentBuilder<CommandSourceStack> unset = literal("unset");
        LiteralArgumentBuilder<CommandSourceStack> inGet = literal("get");
        LiteralArgumentBuilder<CommandSourceStack> inSet = literal("set");
        LiteralArgumentBuilder<CommandSourceStack> inUnset = literal("unset");
        if (map.containsKey("get")) map.get("get").aggregate(get);
        if (map.containsKey("set")) map.get("set").aggregate(set);
        if (map.containsKey("unset")) map.get("unset").aggregate(unset);
        if (map.containsKey("in-get")) map.get("in-get").aggregate(inGet);
        if (map.containsKey("in-set")) map.get("in-set").aggregate(inSet);
        if (map.containsKey("in-unset")) map.get("in-unset").aggregate(inUnset);
        for (GameRules.Category c : GameRules.Category.values()) {
            String k = c.name();
            if (map.containsKey(k)) literalArgumentBuilder.then(map.get(k).aggregate(literal(k)));
            if (map.containsKey("get-"+k)) get.then(map.get("get-"+k).aggregate(literal(k)));
            if (map.containsKey("set-"+k)) set.then(map.get("set-"+k).aggregate(literal(k)));
            if (map.containsKey("unset-"+k)) unset.then(map.get("unset-"+k).aggregate(literal(k)));
            if (map.containsKey("in-get-"+k)) inGet.then(map.get("in-get-"+k).aggregate(literal(k)));
            if (map.containsKey("in-set-"+k)) inSet.then(map.get("in-set-"+k).aggregate(literal(k)));
            if (map.containsKey("in-unset-"+k)) inUnset.then(map.get("in-unset-"+k).aggregate(literal(k)));
        }
        dispatcher.register(builder.then(get).then(set).then(unset).then(
                literal("in").then(Commands.argument("dimension", DimensionArgument.dimension())
                        .then(inGet).then(inSet).then(inUnset)
                )
        ));
        Utils.aggregatorsMap.remove();
        return original.call(dispatcher, command);
    }

    @WrapOperation(
            method = "executeSet",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/GameRules$Rule;set(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)V"
            )
    )
    private static void executeSetGameRuleSetWrapper(
            GameRules.Value<?> instance, CommandContext<CommandSourceStack> context, String name,
            Operation<Void> original
    ) throws Exception {
        try {
            original.call(instance, context, name);
        } catch (EncapsulatedException ex) {
            throw ex.exception;
        }
    }

    @Unique
    private static int unruled_listOverridesSimple(CommandContext<CommandSourceStack> context) {
        return unruled_listOverrides(context, context.getSource().getLevel());
    }

    @Unique
    private static int unruled_listOverridesInWorld(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return unruled_listOverrides(context, DimensionArgument.getDimension(context, "dimension"));
    }

    @Unique
    private static int unruled_listOverrides(
            CommandContext<CommandSourceStack> context, ServerLevel world
    ) {
        OverridesManager overrides = ((IGameruleOverridesProvider)world).unruled_getOverridesManager();
        Set<GameRules.Key<?>> set = overrides.getOverrides().getOverrides();
        StringBuilder sb = new StringBuilder();
        set.forEach(k -> sb.append("\n - ").append(k.getId()).append(": ").append(overrides.get(k).serialize()));
        context.getSource().sendSuccess(() -> Component.translatableWithFallback(
                "commands.gamerule_override.list",
                LangFallbacks.OVERRIDE_LIST.format(world.dimension().location(), set.size(), sb.toString()),
                world.dimension(), set.size(), sb.toString()), false);
        return set.size();
    }
}
