package mc.recraftors.unruled_api.mixin;

import mc.recraftors.unruled_api.rules.*;
import mc.recraftors.unruled_api.utils.IGameRulesProvider;
import mc.recraftors.unruled_api.utils.IGamerulesInitializer;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Mixin(GameRules.class)
public abstract class GameRulesMixin implements IGameRulesProvider, IGamerulesInitializer {
    @Shadow public abstract <T extends GameRules.Value<T>> T get(GameRules.Key<T> key);

    @Shadow @Final private Map<GameRules.Key<?>, GameRules.Value<?>> rules;

    @Override
    public float unruled_getFloat(GameRules.Key<FloatRule> key) {
        return this.get(key).get();
    }

    @Override
    public long unruled_getLong(GameRules.Key<LongRule> key) {
        return this.get(key).get();
    }

    @Override
    public double unruled_getDouble(GameRules.Key<DoubleRule> key) {
        return this.get(key).get();
    }

    @Override
    public <T extends Enum<T>> T unruled_getEnum(GameRules.Key<EnumRule<T>> key) {
        return this.get(key).get();
    }

    @Override
    public String unruled_getString(GameRules.Key<StringRule> key) {
        return this.get(key).get();
    }

    @Override
    public EntitySelector unruled_getEntitySelector(GameRules.Key<EntitySelectorRule> key) {
        return this.get(key).get();
    }

    @Override
    public <T> T unruled_getRegistryEntry(GameRules.Key<RegistryEntryRule<T>> key) {
        return this.get(key).get();
    }

    @Override
    public String unruled_getText(GameRules.Key<TextRule> key) {
        return this.get(key).get();
    }

    @Override
    public Map<String, GameRules.Key<?>> unruled_getMatchingRules(Set<String> names) {
        return this.rules.keySet().stream()
                .filter(k -> names.contains(k.getId()))
                .collect(Collectors.toUnmodifiableMap(GameRules.Key::getId, k -> k));
    }

    @Override
    public void unruled_loadRegistryEntries(RegistryAccess registryManager) {
        this.rules.forEach((k, r) -> {
            if (!(r instanceof RegistryEntryRule<?> rr)) return;
            rr.provide(registryManager);
        });
    }
}
