package mc.recraftors.unruled_api.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import mc.recraftors.unruled_api.utils.*;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;
import mc.recraftors.unruled_api.rules.EnumRule;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.function.Supplier;

@Mixin(GameRules.Type.class)
public abstract class GameRulesTypeMixin <T extends GameRules.Value<T>> implements ServerBoundAccessor {
    @Shadow @Final
    Supplier<ArgumentType<?>> argumentType;

    @Shadow @Final FeatureFlagSet requiredFeatures;

    @Unique
    private boolean unruled_serverBound = false;

    @Override
    public void unruled_setServerBound(boolean b) {
        this.unruled_serverBound = b;
    }

    @Override
    public boolean unruled_isServerBound() {
        return this.unruled_serverBound;
    }

    @Inject(method = "argument", at = @At("RETURN"))
    private void onArgumentHeadSpecialArgHandler(
            String name, CallbackInfoReturnable<RequiredArgumentBuilder<CommandSourceStack, ?>> cir) {
        if (this.argumentType instanceof EnumArgSupplier<?> supplier) {
            cir.getReturnValue().suggests((context, builder) ->
                    SharedSuggestionProvider.suggest(EnumRule.getEnumNames(supplier.unruled_getTargetClass()), builder));
        }
    }

    @WrapOperation(method = "argument", at = @At(value = "INVOKE", target = "Ljava/util/function/Supplier;get()Ljava/lang/Object;"))
    private <T> T unruled_applyRegRuleAccess(Supplier<T> instance, Operation<T> original) {
        if (instance instanceof RegArgBuilder<?> builder) {
            // noinspection unchecked
            return (T) builder.build(Utils.registryAccessThreadLocal.get(), this.requiredFeatures);
        }
        return original.call(instance);
    }

    @WrapMethod(method = "createRule")
    private T unruled_createRuleApplyServerBound(Operation<T> original) {
        T t = original.call();
        ((ServerBoundAccessor)t).unruled_setServerBound(this.unruled_serverBound);
        return t;
    }
}
