package mc.recraftors.unruled_api.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import mc.recraftors.unruled_api.CategoryProvider;
import mc.recraftors.unruled_api.UnruledEarlyUtils;
import mc.recraftors.unruled_api.utils.Utils;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;

import java.util.*;

@Mixin(GameRules.Category.class)
public abstract class GamerulesCategoryMixin {
    @Invoker("<init>")
    private static GameRules.Category constructorInvoker(String name, int ord, String translate) {
        return null;
    }

    @WrapOperation(
            method = "<clinit>",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/GameRules$Category;method_36694()[Lnet/minecraft/world/GameRules$Category;"
            )
    )
    private static GameRules.Category[] unruled_addCustomCategories(Operation<GameRules.Category[]> original) {
        GameRules.Category[] base = original.call();
        Map<Integer, GameRules.Category> ordMap = new HashMap<>();
        Map<String, GameRules.Category> nameMap = new HashMap<>();
        Map<String, Set<CategoryProvider>> providerMap = new HashMap<>();
        for (GameRules.Category c : base) {
            ordMap.put(c.ordinal(), c);
            nameMap.put(c.name(), c);
        }
        for (CategoryProvider c : UnruledEarlyUtils.CATEGORY_PROVIDERS) {
            String s = Utils.enumNameCorrector(c.ruleName());
            if (nameMap.containsKey(s)) continue;
            providerMap.computeIfAbsent(s, k -> new HashSet<>()).add(c);
        }
        for (Map.Entry<String, Set<CategoryProvider>> entry : providerMap.entrySet()) {
            GameRules.Category c = constructorInvoker(entry.getKey(), ordMap.size(), "gamerule.category."+entry.getKey().toLowerCase());
            ordMap.put(ordMap.size(), c);
            entry.getValue().forEach(cp -> cp.categoryReceiver(c));
        }
        GameRules.Category[] copy = Arrays.copyOf(base,ordMap.size());
        for (int i = 0; i < copy.length; i++) {
            copy[i] = ordMap.get(i);
        }
        return copy;
    }
}
