package mc.recraftors.unruled_api.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import mc.recraftors.unruled_api.rules.OverridesManager;
import mc.recraftors.unruled_api.utils.IGameruleOverridesProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import java.util.concurrent.Executor;

@Mixin(ServerLevel.class)
public abstract class ServerWorldMixin extends Level implements IGameruleOverridesProvider {

    protected ServerWorldMixin(WritableLevelData properties, ResourceKey<Level> registryRef, RegistryAccess registryManager, Holder<DimensionType> dimensionEntry, boolean isClient, boolean debugWorld, long seed, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, isClient, debugWorld, seed, maxChainedNeighborUpdates);
    }

    @Shadow public abstract DimensionDataStorage getPersistentStateManager();

    @Shadow
    public abstract GameRules getGameRules();

    @Unique private OverridesManager gamerulesOverrides;

    @SuppressWarnings("brittleShift")
    @Inject(
            method = "<init>",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/PersistentStateManager;getOrCreate(Lnet/minecraft/world/PersistentStateType;)Lnet/minecraft/world/PersistentState;",
                    shift = At.Shift.AFTER
            )
    )
    private void unruled_initGamerulesOverridesManager(
            MinecraftServer server, Executor workerExecutor, LevelStorageSource.LevelStorageAccess session,
            ServerLevelData properties, ResourceKey<Level> worldKey, LevelStem dimensionOptions,
            ChunkProgressListener worldGenerationProgressListener, boolean debugWorld, long seed,
            List<CustomSpawner> spawners, boolean shouldTickTime, RandomSequences random, CallbackInfo ci
    ) {
        this.gamerulesOverrides = this.getPersistentStateManager().computeIfAbsent(OverridesManager.getPersistentStateType());
    }

    @Inject(method="getGameRules", at = @At("HEAD"), cancellable = true)
    private void unruled_getGameRulesOverrides(CallbackInfoReturnable<GameRules> cir) {
        cir.setReturnValue(this.gamerulesOverrides.getOverrides());
    }

    @Override
    public OverridesManager unruled_getOverridesManager() {
        return this.gamerulesOverrides;
    }

    @WrapOperation(method = "tickTime", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/ServerWorldProperties;getGameRules()Lnet/minecraft/world/GameRules;"))
    private GameRules unruled_allowDaylightCycleOverride(ServerLevelData instance, Operation<GameRules> original) {
        return this.getGameRules();
    }
}
