package mc.recraftors.unruled_api.mixin;

import mc.recraftors.unruled_api.utils.Utils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalLong;

@Environment(EnvType.CLIENT)
@Mixin(WorldCreationUiState.class)
public abstract class WorldCreatorMixin {
    @Shadow private GameRules gameRules;

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    @Inject(method = "<init>", at = @At("TAIL"))
    private void unruled_loadDefaultRules(
            Path savesDirectory, WorldCreationContext generatorOptionsHolder,
            Optional<ResourceKey<WorldPreset>> defaultWorldType, OptionalLong seed, CallbackInfo ci
    ) {
        ((GameRulesInvoker)this.gameRules).invokeLoad(
                Utils.loadDynamicFromJsonFile("config/default_gamerules.json"));
    }
}
