package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.context.CommandContext;
import mc.recraftors.unruled_api.UnruledApi;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameRulesProvider;
import mc.recraftors.unruled_api.utils.ServerBoundAccessor;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class GameRulesOverrides extends GameRules {
    private final GameRules base;
    private final Map<GameRules.Key<?>, GameRules.Value<?>> overrides;

    public GameRulesOverrides(GameRules base, Map<String, String> map, FeatureFlagSet featureSet) {
        super(featureSet);
        this.base = base;
        this.overrides = new HashMap<>();
        Map<String, Key<?>> keyMap = ((IGameRulesProvider) base).unruled_getMatchingRules(map.keySet());
        keyMap.forEach((k, v) -> {
            String s = map.get(k);
            try {
                Value<?> rule = base.getRule(v);
                if (!((ServerBoundAccessor)rule).unruled_isServerBound()) {
                    this.overrides.put(v, ((GameruleAccessor<?>) rule.copy()).unruled_setValue(s));
                }
            } catch (Exception ex) {
                UnruledApi.LOGGER.warn("Unable to deserialize override for {} from {}", k, s);
            }
        });
    }

    public boolean isEmpty() {
        return this.overrides.isEmpty();
    }

    public <T extends Value<T>> boolean hasOverride(Key<T> key) {
        return this.overrides.containsKey(key);
    }

    public <T extends Value<T>> boolean override(Key<T> key, CommandContext<CommandSourceStack> context) {
        if (!this.overrides.containsKey(key)) {
            T baseRule = this.base.getRule(key);
            if (((ServerBoundAccessor)baseRule).unruled_isServerBound()) return false;
            this.overrides.put(key, baseRule.copy());
        }
        this.overrides.get(key).setFromArgument(context, "value");
        return true;
    }

    public <T extends Value<T>> boolean removeOverride(Key<T> key) {
        if (this.hasOverride(key)) {
            this.overrides.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public <T extends Value<T>> T getRule(Key<T> key) {
        //noinspection unchecked
        return Optional.ofNullable((T) this.overrides.get(key))
                .orElseGet(() -> this.base.getRule(key));
    }

    public Set<GameRules.Key<?>> getOverrides() {
        return this.overrides.keySet();
    }
}
