package mc.recraftors.unruled_api.utils;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

@Environment(EnvType.CLIENT)
public final class ClientUtils {
    public static <T> Registry<T> getClientWorldRegistryOrThrow(ResourceKey<? extends Registry<T>> key) {
        Level world = Minecraft.getInstance().level;
        if (world == null) throw new UnsupportedOperationException("No loaded world");
        return world.registryAccess().lookupOrThrow(key);
    }
}
