package mc.recraftors.unruled_api.utils;

import com.mojang.brigadier.builder.ArgumentBuilder;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;

public final class CommandAggregator {
    private final Set<ArgumentBuilder<CommandSourceStack, ?>> set = new HashSet<>();

    public void add(ArgumentBuilder<CommandSourceStack, ?> arg) {
        this.set.add(arg);
    }

    public ArgumentBuilder<CommandSourceStack, ?> aggregate(ArgumentBuilder<CommandSourceStack, ?> builder) {
        this.set.forEach(builder::then);
        return builder;
    }
}
