package mc.recraftors.unruled_api.utils;

import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public class SimpleRegistryWrapperImpl <T> implements HolderLookup.RegistryLookup<T> {
    private final HolderLookup<T> base;
    private final ResourceKey<? extends Registry<? extends T>> key;

    public SimpleRegistryWrapperImpl(HolderLookup<T> base, ResourceKey<? extends Registry<? extends T>> key) {
        this.base = base;
        this.key = key;
    }

    @Override
    public ResourceKey<? extends Registry<? extends T>> key() {
        return this.key;
    }

    @Override
    public Lifecycle registryLifecycle() {
        return Lifecycle.stable(); // fallback I guess
    }

    @Override
    public Stream<Holder.Reference<T>> listElements() {
        return base.listElements();
    }

    @Override
    public Stream<HolderSet.Named<T>> listTags() {
        return base.listTags();
    }

    @Override
    public Optional<Holder.Reference<T>> get(ResourceKey<T> key) {
        return base.get(key);
    }

    @Override
    public Optional<HolderSet.Named<T>> get(TagKey<T> tag) {
        return base.get(tag);
    }
}
