package mc.recraftors.unruled_api.widgets;

import mc.recraftors.unruled_api.rules.LongRule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.worldselection.EditGameRulesScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import java.util.List;

public class LongRuleWidget extends NamedRuleWidget {
    private final EditBox valueWidget;

    public LongRuleWidget(Component name, List<FormattedCharSequence> description, String ruleName, LongRule rule, EditGameRulesScreen screen) {
        super(description, name, screen);
        this.valueWidget = new EditBox(Minecraft.getInstance().font, 10, 5, 42, 20, name.copy().append("\n").append(ruleName).append("\n"));
        this.valueWidget.setValue(rule.serialize());
        this.valueWidget.setResponder(val -> {
            if (rule.validate(val)) {
                this.valueWidget.setTextColor(0xE0E0E0);
                screen.clearInvalid(this);
            } else {
                this.valueWidget.setTextColor(0xFF0000);
                screen.markInvalid(this);
            }
        });
        this.children.add(this.valueWidget);
    }

    @SuppressWarnings("SuspiciousNameCombination")
    @Override
    public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.drawName(context, y, x);
        this.valueWidget.setX(x + entryWidth - 44);
        this.valueWidget.setY(y);
        this.valueWidget.render(context, mouseX, mouseY, tickDelta);
    }
}
