package mc.recraftors.unruled_api.widgets;


import com.google.common.collect.Lists;
import mc.recraftors.unruled_api.utils.ClientProvider;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.worldselection.EditGameRulesScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import java.util.List;

/**
 * Accessible shadow clone of the vanilla gamerule widget.
 * Allows for easy display of custom gamerule types.
 */
@Environment(EnvType.CLIENT)
public abstract class NamedRuleWidget extends EditGameRulesScreen.RuleEntry {
    private final List<FormattedCharSequence> name;
    protected final List<AbstractWidget> children;
    private final EditGameRulesScreen screen;

    @SuppressWarnings("resource")
    protected NamedRuleWidget(List<FormattedCharSequence> description, Component name, EditGameRulesScreen screen) {
        super(description);
        this.children = Lists.newArrayList();
        this.name = ((ClientProvider)screen).unruled_getClient().font.split(name, 175);
        this.screen = screen;
    }

    public EditGameRulesScreen getScreen() {
        return screen;
    }

    @Override
    public List<? extends GuiEventListener> children() {
        return children;
    }

    @Override
    public List<? extends NarratableEntry> narratables() {
        return children;
    }

    @SuppressWarnings({"resource", "SuspiciousNameCombination"})
    protected void drawName(GuiGraphics context, int x, int y) {
        if (this.name.size() == 1) {
            context.drawString(((ClientProvider)screen).unruled_getClient().font, this.name.get(0), y, (x + 5), 0xFFFFFF, false);
        } else if (this.name.size() >= 2) {
            context.drawString(((ClientProvider)screen).unruled_getClient().font, this.name.get(0), y, x, 0xFFFFFF, false);
            context.drawString(((ClientProvider)screen).unruled_getClient().font, this.name.get(1), y, (x + 10), 0xFFFFFF, false);
        }
    }
}
