/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.mixin;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import java.util.function.Function;
import mc.recraftors.unruled_api.mixin.GameruleCommandInvoker;
import mc.recraftors.unruled_api.rules.OverridesManager;
import mc.recraftors.unruled_api.utils.CommandAggregator;
import mc.recraftors.unruled_api.utils.IGameruleOverridesProvider;
import mc.recraftors.unruled_api.utils.LangFallbacks;
import mc.recraftors.unruled_api.utils.ServerBoundAccessor;
import mc.recraftors.unruled_api.utils.Utils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraft/server/commands/GameRuleCommand$1"})
public abstract class GameruleCommandVisitorMixin {
    @Shadow
    @Final
    LiteralArgumentBuilder<CommandSourceStack> val$base;

    @Inject(method={"visit(Lnet/minecraft/world/level/GameRules$Key;Lnet/minecraft/world/level/GameRules$Type;)V"}, at={@At(value="TAIL")})
    private <T extends GameRules.Value<T>> void setupOverridesSubArgs(GameRules.Key<T> key, GameRules.Type<T> type, CallbackInfo ci) {
        String k = key.getCategory().name();
        Map<String, CommandAggregator> map = Utils.aggregatorsMap.get();
        if (map == null) {
            return;
        }
        Function<String, CommandAggregator> builder = s -> new CommandAggregator();
        map.computeIfAbsent(k, builder).add(((LiteralArgumentBuilder)Commands.literal((String)key.getId()).executes(context -> GameruleCommandInvoker.callExecuteQuery((CommandSourceStack)context.getSource(), key))).then(type.createArgument("value").executes(context -> GameruleCommandInvoker.callExecuteSet((CommandContext<CommandSourceStack>)context, key))));
        if (((ServerBoundAccessor)type).unruled_isServerBound()) {
            return;
        }
        LiteralArgumentBuilder get = (LiteralArgumentBuilder)Commands.literal((String)key.getId()).executes(c -> GameruleCommandVisitorMixin.unruled_queryOverrideSimple((CommandContext<CommandSourceStack>)c, key));
        map.computeIfAbsent("get", builder).add((ArgumentBuilder<CommandSourceStack, ?>)get);
        map.computeIfAbsent("get-" + k, builder).add((ArgumentBuilder<CommandSourceStack, ?>)get);
        LiteralArgumentBuilder set = (LiteralArgumentBuilder)Commands.literal((String)key.getId()).then(type.createArgument("value").executes(c -> GameruleCommandVisitorMixin.unruled_setOverrideSimple((CommandContext<CommandSourceStack>)c, key)));
        map.computeIfAbsent("set", builder).add((ArgumentBuilder<CommandSourceStack, ?>)set);
        map.computeIfAbsent("set-" + k, builder).add((ArgumentBuilder<CommandSourceStack, ?>)set);
        LiteralArgumentBuilder unset = (LiteralArgumentBuilder)Commands.literal((String)key.getId()).executes(c -> GameruleCommandVisitorMixin.unruled_unsetOverrideSimple((CommandContext<CommandSourceStack>)c, key));
        map.computeIfAbsent("unset", builder).add((ArgumentBuilder<CommandSourceStack, ?>)unset);
        map.computeIfAbsent("unset-" + k, builder).add((ArgumentBuilder<CommandSourceStack, ?>)unset);
        LiteralArgumentBuilder inGet = (LiteralArgumentBuilder)Commands.literal((String)key.getId()).executes(c -> GameruleCommandVisitorMixin.unruled_queryOverrideInWorld((CommandContext<CommandSourceStack>)c, key));
        map.computeIfAbsent("in-get", builder).add((ArgumentBuilder<CommandSourceStack, ?>)inGet);
        map.computeIfAbsent("in-get-" + k, builder).add((ArgumentBuilder<CommandSourceStack, ?>)inGet);
        LiteralArgumentBuilder inSet = (LiteralArgumentBuilder)Commands.literal((String)key.getId()).then(type.createArgument("value").executes(c -> GameruleCommandVisitorMixin.unruled_setOverrideInWorld((CommandContext<CommandSourceStack>)c, key)));
        map.computeIfAbsent("in-set", builder).add((ArgumentBuilder<CommandSourceStack, ?>)inSet);
        map.computeIfAbsent("in-set-" + k, builder).add((ArgumentBuilder<CommandSourceStack, ?>)inSet);
        LiteralArgumentBuilder inUnset = (LiteralArgumentBuilder)Commands.literal((String)key.getId()).executes(c -> GameruleCommandVisitorMixin.unruled_unsetOverrideInWorld((CommandContext<CommandSourceStack>)c, key));
        map.computeIfAbsent("in-unset", builder).add((ArgumentBuilder<CommandSourceStack, ?>)inUnset);
        map.computeIfAbsent("in-unset-" + k, builder).add((ArgumentBuilder<CommandSourceStack, ?>)inUnset);
    }

    @Unique
    private static <T extends GameRules.Value<T>> int unruled_queryOverrideSimple(CommandContext<CommandSourceStack> context, GameRules.Key<T> key) {
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        return GameruleCommandVisitorMixin.unruled_queryOverride(context, key, world);
    }

    @Unique
    private static <T extends GameRules.Value<T>> int unruled_queryOverrideInWorld(CommandContext<CommandSourceStack> context, GameRules.Key<T> key) throws CommandSyntaxException {
        return GameruleCommandVisitorMixin.unruled_queryOverride(context, key, DimensionArgument.getDimension(context, (String)"dimension"));
    }

    @Unique
    private static <T extends GameRules.Value<T>> int unruled_setOverrideSimple(CommandContext<CommandSourceStack> context, GameRules.Key<T> key) {
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        return GameruleCommandVisitorMixin.unruled_setOverride(context, key, world);
    }

    @Unique
    private static <T extends GameRules.Value<T>> int unruled_setOverrideInWorld(CommandContext<CommandSourceStack> context, GameRules.Key<T> key) throws CommandSyntaxException {
        return GameruleCommandVisitorMixin.unruled_setOverride(context, key, DimensionArgument.getDimension(context, (String)"dimension"));
    }

    @Unique
    private static <T extends GameRules.Value<T>> int unruled_unsetOverrideSimple(CommandContext<CommandSourceStack> context, GameRules.Key<T> key) {
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        return GameruleCommandVisitorMixin.unruled_unsetOverride(context, key, world);
    }

    @Unique
    private static <T extends GameRules.Value<T>> int unruled_unsetOverrideInWorld(CommandContext<CommandSourceStack> context, GameRules.Key<T> key) throws CommandSyntaxException {
        return GameruleCommandVisitorMixin.unruled_unsetOverride(context, key, DimensionArgument.getDimension(context, (String)"dimension"));
    }

    @Unique
    private static <T extends GameRules.Value<T>> int unruled_queryOverride(CommandContext<CommandSourceStack> context, GameRules.Key<T> key, ServerLevel world) {
        OverridesManager manager = ((IGameruleOverridesProvider)world).unruled_getOverridesManager();
        String keyName = key.getId();
        ResourceLocation worldId = world.dimension().location();
        if (!manager.hasOverride(key)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableWithFallback((String)"commands.gamerule_override.none", (String)LangFallbacks.OVERRIDE_NONE.format(keyName, worldId), (Object[])new Object[]{keyName, worldId.toString()}), false);
            return 0;
        }
        Object rule = manager.get(key);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableWithFallback((String)"commands.gamerule_override.query", (String)LangFallbacks.OVERRIDE_QUERY.format(keyName, worldId, rule.toString()), (Object[])new Object[]{keyName, worldId.toString(), rule.toString()}), false);
        return rule.getCommandResult();
    }

    @Unique
    private static <T extends GameRules.Value<T>> int unruled_setOverride(CommandContext<CommandSourceStack> context, GameRules.Key<T> key, ServerLevel world) {
        OverridesManager manager = ((IGameruleOverridesProvider)world).unruled_getOverridesManager();
        String keyName = key.getId();
        ResourceLocation worldId = world.dimension().location();
        boolean b = manager.override(key, context);
        if (!b) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableWithFallback((String)"commands.gamerule_override.server_bound", (String)LangFallbacks.OVERRIDE_SB.format(keyName), (Object[])new Object[]{keyName}), false);
            return ((CommandSourceStack)context.getSource()).getServer().getGameRules().getRule(key).getCommandResult();
        }
        Object rule = manager.get(key);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableWithFallback((String)"commands.gamerule_override.set", (String)LangFallbacks.OVERRIDE_SET.format(keyName, worldId, rule.toString()), (Object[])new Object[]{keyName, worldId.toString(), rule.toString()}), true);
        return rule.getCommandResult();
    }

    @Unique
    private static <T extends GameRules.Value<T>> int unruled_unsetOverride(CommandContext<CommandSourceStack> context, GameRules.Key<T> key, ServerLevel world) {
        OverridesManager manager = ((IGameruleOverridesProvider)world).unruled_getOverridesManager();
        String keyName = key.getId();
        ResourceLocation worldId = world.dimension().location();
        boolean b = manager.removeOverride(key);
        String tr = "command.gamerule_override." + (b ? "unset" : "none");
        LangFallbacks fb = b ? LangFallbacks.OVERRIDE_UNSET : LangFallbacks.OVERRIDE_NONE;
        T rule = manager.get(key);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableWithFallback((String)tr, (String)fb.format(keyName, worldId), (Object[])new Object[]{keyName, worldId}), true);
        return rule.getCommandResult();
    }
}

