/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import java.util.Optional;
import mc.recraftors.unruled_api.UnruledApi;
import mc.recraftors.unruled_api.rules.RuleBuilder;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameRulesVisitor;
import mc.recraftors.unruled_api.utils.IGameruleAdapter;
import mc.recraftors.unruled_api.utils.IGameruleValidator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleRule
extends GameRules.Value<DoubleRule>
implements GameruleAccessor<Double> {
    private double value;
    private IGameruleValidator<Double> validator;
    private IGameruleAdapter<Double> adapter;

    public DoubleRule(GameRules.Type<DoubleRule> type, double initialValue, IGameruleValidator<Double> validator, IGameruleAdapter<Double> adapter) {
        super(type);
        Objects.requireNonNull(validator);
        Objects.requireNonNull(adapter);
        this.value = initialValue;
        this.validator = validator;
        this.adapter = adapter;
    }

    public DoubleRule(GameRules.Type<DoubleRule> type, double initialValue) {
        this(type, initialValue, IGameruleValidator::alwaysTrue, Optional::of);
    }

    public double get() {
        return this.value;
    }

    public void set(double value, MinecraftServer server) {
        if (this.validator.validate(value)) {
            this.value = value;
            this.onChanged(server);
            return;
        }
        Optional<Double> o = this.adapter.adapt(value);
        if (o.isPresent() && this.validator.validate(o.get())) {
            this.value = o.get();
            this.onChanged(server);
        }
    }

    public boolean validate(String input) {
        try {
            double d = Double.parseDouble(input);
            if (this.validator.validate(d)) {
                this.value = Double.parseDouble(input);
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static double parseDouble(String input) {
        if (!input.isEmpty()) {
            try {
                return Double.parseDouble(input);
            }
            catch (NumberFormatException e) {
                UnruledApi.LOGGER.warn("Failed to parse double from '{}'", (Object)input);
            }
        }
        return 0.0;
    }

    protected void updateFromArgument(CommandContext<CommandSourceStack> context, String name) {
        double d = DoubleArgumentType.getDouble(context, (String)name);
        boolean b = this.validator.validate(d);
        if (b) {
            this.value = d;
            return;
        }
        Optional<Double> o = this.adapter.adapt(d);
        if (o.isPresent() && (b = this.validator.validate(o.get()))) {
            this.value = o.get();
            return;
        }
        throw new IllegalArgumentException("Invalid value " + d);
    }

    protected void deserialize(String value) {
        double d = DoubleRule.parseDouble(value);
        boolean b = this.validator.validate(d);
        if (b) {
            this.value = d;
            return;
        }
        Optional<Double> o = this.adapter.adapt(d);
        if (o.isPresent() && (b = this.validator.validate(o.get()))) {
            this.value = o.get();
        }
    }

    public String serialize() {
        return Double.toString(this.value);
    }

    public int getCommandResult() {
        return (int)this.value;
    }

    protected DoubleRule getThis() {
        return this;
    }

    public DoubleRule copy() {
        return new DoubleRule((GameRules.Type<DoubleRule>)this.type, this.value, this.validator, this.adapter);
    }

    public void setValue(DoubleRule rule, @Nullable MinecraftServer server) {
        Optional<Double> o;
        double d = rule.get();
        boolean b = this.validator.validate(d);
        if (!b && (o = this.adapter.adapt(d)).isPresent() && this.validator.validate(o.get())) {
            d = o.get();
            b = true;
        }
        if (b) {
            this.value = d;
            this.onChanged(server);
        }
    }

    @Override
    public IGameruleValidator<Double> unruled_getValidator() {
        return this.validator;
    }

    @Override
    public void unruled_setValidator(IGameruleValidator<Double> validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    @Override
    public IGameruleAdapter<Double> unruled_getAdapter() {
        return this.adapter;
    }

    @Override
    public void unruled_setAdapter(IGameruleAdapter<Double> adapter) {
        this.adapter = Objects.requireNonNull(adapter);
    }

    public static class Builder
    extends RuleBuilder<DoubleRule, Double> {
        public Builder(double initialValue) {
            super(DoubleArgumentType::doubleArg, Builder::acceptor, DoubleRule.class, initialValue);
        }

        @Override
        @NotNull
        protected DoubleRule ruleBuilder(GameRules.Type<DoubleRule> type) {
            return new DoubleRule(type, (Double)this.initialValue, this.validator, this.adapter);
        }

        static void acceptor(GameRules.GameRuleTypeVisitor consumer, GameRules.Key<DoubleRule> key, GameRules.Type<DoubleRule> type) {
            ((IGameRulesVisitor)consumer).unruled_visitDouble(key, type);
        }
    }
}

