/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import mc.recraftors.unruled_api.UnruledApi;
import mc.recraftors.unruled_api.impl.FullRegistryWrapperLookup;
import mc.recraftors.unruled_api.rules.RuleBuilder;
import mc.recraftors.unruled_api.utils.ClientUtils;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameRulesVisitor;
import mc.recraftors.unruled_api.utils.IGameruleAdapter;
import mc.recraftors.unruled_api.utils.IGameruleValidator;
import mc.recraftors.unruled_api.utils.Utils;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;
import net.neoforged.api.distmarker.Dist;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryEntryRule<T>
extends GameRules.Value<RegistryEntryRule<T>>
implements GameruleAccessor<T> {
    private static final DynamicCommandExceptionType UNKNOWN_REGISTRY_ENTRY = new DynamicCommandExceptionType(id -> Component.translatableWithFallback((String)"commands.unruled_api.unknown_registry_entry", (String)"Unknown entry %s in registry", (Object[])new Object[]{id}));
    private ProviderEntry<T> provider;
    private Registry<T> registry;
    private T value;
    private IGameruleValidator<T> validator;
    private IGameruleAdapter<T> adapter;

    public RegistryEntryRule(GameRules.Type<RegistryEntryRule<T>> type, Registry<T> registry, T initialValue, IGameruleValidator<T> validator, IGameruleAdapter<T> adapter) throws UnsupportedOperationException {
        super(type);
        if (registry.getKey(initialValue) == null) {
            throw new UnsupportedOperationException("initial value must be a registry member");
        }
        this.registry = Objects.requireNonNull(registry);
        this.provider = new ProviderEntry(registry.key(), Objects.requireNonNull(registry.getKey(initialValue)));
        this.value = Objects.requireNonNull(initialValue);
        this.validator = Objects.requireNonNull(validator);
        this.adapter = Objects.requireNonNull(adapter);
    }

    public RegistryEntryRule(GameRules.Type<RegistryEntryRule<T>> type, ResourceKey<? extends Registry<T>> registryKey, ResourceLocation valueKey, IGameruleValidator<T> validator, IGameruleAdapter<T> adapter) {
        super(type);
        this.registry = null;
        this.provider = new ProviderEntry(Objects.requireNonNull(registryKey), Objects.requireNonNull(valueKey));
        this.validator = Objects.requireNonNull(validator);
        this.adapter = Objects.requireNonNull(adapter);
    }

    public RegistryEntryRule(GameRules.Type<RegistryEntryRule<T>> type, Registry<T> registry, T initialValue) {
        this(type, registry, initialValue, IGameruleValidator::alwaysTrue, Optional::of);
    }

    private static <V> Supplier<ArgumentType<?>> argSupplierBuilder(ResourceKey<? extends Registry<V>> key, FeatureFlagSet featureSet) {
        return () -> {
            try {
                return ResourceArgument.resource((CommandBuildContext)new FullRegistryWrapperLookup(featureSet, Utils.registryAccessThreadLocal.get()).toCommandRegAccessAccess(), (ResourceKey)key);
            }
            catch (Exception ex) {
                return ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)key);
            }
        };
    }

    public void provide(RegistryAccess registryManager) {
        Object t;
        Objects.requireNonNull(registryManager);
        if (this.registry == null) {
            this.registry = Objects.requireNonNull(registryManager.lookupOrThrow(this.provider.regKey()));
        }
        if ((t = this.registry.getValue(this.provider.entryId())) != null) {
            this.set(t);
        }
    }

    public T get() {
        return this.value;
    }

    public void set(T value, @Nullable MinecraftServer server) {
        this.bump(value, server);
    }

    private void bump(T value, MinecraftServer server) {
        boolean b = this.validator.validate(value);
        if (!b) {
            Optional<T> o = this.adapter.adapt(value);
            boolean bl = b = o.isPresent() && this.validator.validate(value = o.get());
        }
        if (b) {
            this.value = value;
            this.provider = Objects.requireNonNull(this.provider.withId(this.registry.getKey(value)));
            this.onChanged(server);
        }
    }

    private void set(T t) {
        if (this.validator.validate(t)) {
            this.value = t;
            return;
        }
        Optional<T> o = this.adapter.adapt(t);
        if (o.isEmpty() || !this.validator.validate(o.get())) {
            return;
        }
        this.value = o.get();
    }

    public boolean validate(String input) {
        if (this.registry == null && FabricLoader.getInstance().getEnvironmentType() == Dist.CLIENT) {
            this.registry = ClientUtils.getClientWorldRegistryOrThrow(this.provider.regKey());
        }
        if (this.registry == null) {
            return false;
        }
        Optional<T> o = RegistryEntryRule.parseInput(input, this.registry);
        if (o.isPresent() && this.validator.validate(o.get())) {
            this.value = o.get();
            return true;
        }
        return false;
    }

    private static <U> Optional<U> parseInput(String input, Registry<U> registry) {
        ResourceLocation id = ResourceLocation.tryParse((String)input);
        if (id == null || !registry.containsKey(id)) {
            return Optional.empty();
        }
        return Optional.ofNullable(registry.getValue(id));
    }

    protected void updateFromArgument(CommandContext<CommandSourceStack> context, String name) {
        try {
            Holder.Reference entry = ResourceArgument.getResource(context, (String)name, (ResourceKey)this.registry.key());
            Object t = this.registry.getValue(entry.key().location());
            this.set(Objects.requireNonNull(t));
        }
        catch (IllegalArgumentException e) {
            try {
                ResourceOrTagKeyArgument.Result predicate = ResourceOrTagKeyArgument.getResourceOrTagKey(context, (String)name, (ResourceKey)this.registry.key(), (DynamicCommandExceptionType)UNKNOWN_REGISTRY_ENTRY);
                Holder.Reference entry = (Holder.Reference)this.registry.listElements().filter(predicate).findFirst().orElseThrow(() -> new IllegalArgumentException("No entry found"));
                this.set(entry.value());
            }
            catch (CommandSyntaxException ex) {
                throw new IllegalArgumentException(e);
            }
        }
        catch (CommandSyntaxException | IllegalStateException | NullPointerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void deserialize(String value) {
        if (this.registry == null) {
            return;
        }
        RegistryEntryRule.parseInput(value, this.registry).ifPresentOrElse(this::set, () -> {
            if (this.registry != null) {
                UnruledApi.LOGGER.warn("Unable to find an entry of {} matching '{}'", (Object)this.registry.key(), (Object)value);
            } else {
                this.provider = this.provider.withId(ResourceLocation.tryParse((String)value));
            }
        });
    }

    public String serialize() {
        if (this.registry == null) {
            return this.provider.entryId.toString();
        }
        return Objects.requireNonNull(this.registry.getKey(this.value)).toString();
    }

    public int getCommandResult() {
        return this.registry.getId(this.value);
    }

    protected RegistryEntryRule<T> getThis() {
        return this;
    }

    public RegistryEntryRule<T> copy() {
        if (this.registry == null) {
            return new RegistryEntryRule<T>(this.type, this.provider.regKey, this.provider.entryId, this.validator, this.adapter);
        }
        return new RegistryEntryRule<T>(this.type, this.registry, this.value, this.validator, this.adapter);
    }

    public void setValue(RegistryEntryRule<T> rule, @Nullable MinecraftServer server) {
        this.bump(rule.value, server);
    }

    @Override
    public IGameruleValidator<T> unruled_getValidator() {
        return this.validator;
    }

    @Override
    public void unruled_setValidator(IGameruleValidator<T> validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    @Override
    public IGameruleAdapter<T> unruled_getAdapter() {
        return this.adapter;
    }

    @Override
    public void unruled_setAdapter(IGameruleAdapter<T> adapter) {
        this.adapter = Objects.requireNonNull(adapter);
    }

    private record ProviderEntry<T>(ResourceKey<? extends Registry<T>> regKey, ResourceLocation entryId) {
        ProviderEntry<T> withId(ResourceLocation id) {
            return new ProviderEntry<T>(this.regKey, id);
        }
    }

    public static class Builder<V>
    extends RuleBuilder<RegistryEntryRule<V>, V> {
        private final Registry<V> registry;
        private final ProviderEntry<V> provider;

        public Builder(Registry<V> registry, V initialValue) {
            super(RegistryEntryRule.argSupplierBuilder(registry.key(), FeatureFlagSet.of()), Builder::acceptor, RegistryEntryRule.class, initialValue);
            this.registry = Objects.requireNonNull(registry);
            this.provider = null;
        }

        public Builder(ResourceKey<? extends Registry<V>> regKey, ResourceLocation valueId) {
            super(RegistryEntryRule.argSupplierBuilder(regKey, FeatureFlagSet.of()), Builder::acceptor, RegistryEntryRule.class, null);
            this.registry = null;
            this.provider = new ProviderEntry(regKey, valueId);
        }

        @Override
        @NotNull
        protected RegistryEntryRule<V> ruleBuilder(GameRules.Type<RegistryEntryRule<V>> type) {
            if (this.registry == null) {
                return new RegistryEntryRule<V>(type, this.provider.regKey, this.provider.entryId, this.validator, this.adapter);
            }
            return new RegistryEntryRule<V>(type, this.registry, this.initialValue, this.validator, this.adapter);
        }

        static <U> void acceptor(GameRules.GameRuleTypeVisitor consumer, GameRules.Key<RegistryEntryRule<U>> key, GameRules.Type<RegistryEntryRule<U>> type) {
            ((IGameRulesVisitor)consumer).unruled_visitRegistryEntry(key, type);
        }
    }
}

