/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mc.recraftors.unruled_api.impl.GameruleValidatorAdapter;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameruleAdapter;
import mc.recraftors.unruled_api.utils.IGameruleValidator;
import mc.recraftors.unruled_api.utils.ServerBoundAccessor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.NotNull;

public abstract class RuleBuilder<T extends GameRules.Value<T>, V> {
    protected final Supplier<ArgumentType<?>> argumentSupplier;
    protected final GameRules.VisitorCaller<T> screenVisitor;
    protected final Class<T> ruleClass;
    protected V initialValue;
    protected BiConsumer<MinecraftServer, T> changeCallback;
    protected IGameruleValidator<V> validator;
    protected IGameruleAdapter<V> adapter;
    protected FeatureFlagSet featureSet;
    protected boolean serverBound;

    protected RuleBuilder(Supplier<ArgumentType<?>> argumentSupplier, GameRules.VisitorCaller<T> screenVisitor, Class<T> ruleClass, V initialValue) {
        this.argumentSupplier = Objects.requireNonNull(argumentSupplier);
        this.screenVisitor = Objects.requireNonNull(screenVisitor);
        this.ruleClass = Objects.requireNonNull(ruleClass);
        this.initialValue = initialValue;
        this.changeCallback = (w, s) -> {};
        this.validator = IGameruleValidator::alwaysTrue;
        this.adapter = Optional::of;
        this.featureSet = FeatureFlagSet.of();
    }

    @NotNull
    protected abstract T ruleBuilder(GameRules.Type<T> var1);

    protected final FeatureFlagSet getFeatureSet() {
        return this.featureSet;
    }

    public final RuleBuilder<T, V> setChangeCallback(BiConsumer<MinecraftServer, T> changeCallback) {
        this.changeCallback = Objects.requireNonNull(changeCallback);
        return this;
    }

    public final RuleBuilder<T, V> setValidator(IGameruleValidator<V> validator) {
        this.validator = Objects.requireNonNull(validator);
        return this;
    }

    public final RuleBuilder<T, V> setAdapter(IGameruleAdapter<V> adapter) {
        this.adapter = Objects.requireNonNull(adapter);
        return this;
    }

    public final RuleBuilder<T, V> setValidatorAdapter(GameruleValidatorAdapter<V> validatorAdapter) {
        Objects.requireNonNull(validatorAdapter);
        this.validator = validatorAdapter;
        this.adapter = validatorAdapter;
        return this;
    }

    public final RuleBuilder<T, V> setFeatureSet(FeatureFlagSet featureSet) {
        this.featureSet = Objects.requireNonNull(featureSet);
        return this;
    }

    public final RuleBuilder<T, V> setServerBound(boolean serverBound) {
        this.serverBound = serverBound;
        return this;
    }

    public GameRules.Type<T> build() {
        GameRules.Type type = new GameRules.Type(this.argumentSupplier, this::ruleBuilder, this.changeCallback, this.screenVisitor, this.ruleClass, this.featureSet);
        ((ServerBoundAccessor)type).unruled_setServerBound(this.serverBound);
        return type;
    }

    public GameRules.Key<T> register(String name, GameRules.Category category) {
        return GameRules.register((String)name, (GameRules.Category)category, this.build());
    }

    public static class IntRuleBuilder
    extends RuleBuilder<GameRules.IntegerValue, Integer> {
        public IntRuleBuilder(int initialValue) {
            super(IntegerArgumentType::integer, GameRules.GameRuleTypeVisitor::visitInteger, GameRules.IntegerValue.class, initialValue);
        }

        @Override
        @NotNull
        protected GameRules.IntegerValue ruleBuilder(GameRules.Type<GameRules.IntegerValue> type) {
            GameRules.IntegerValue rule = new GameRules.IntegerValue(type, ((Integer)this.initialValue).intValue());
            GameruleAccessor accessor = (GameruleAccessor)rule;
            accessor.unruled_setValidator(this.validator);
            accessor.unruled_setAdapter(this.adapter);
            return rule;
        }
    }
}

