/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import java.util.Optional;
import mc.recraftors.unruled_api.rules.RuleBuilder;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameRulesVisitor;
import mc.recraftors.unruled_api.utils.IGameruleAdapter;
import mc.recraftors.unruled_api.utils.IGameruleValidator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextRule
extends GameRules.Value<TextRule>
implements GameruleAccessor<String> {
    private String value;
    private IGameruleValidator<String> validator;
    private IGameruleAdapter<String> adapter;

    public TextRule(GameRules.Type<TextRule> type, String initialValue, IGameruleValidator<String> validator, IGameruleAdapter<String> adapter) {
        super(type);
        Objects.requireNonNull(initialValue);
        Objects.requireNonNull(validator);
        Objects.requireNonNull(adapter);
        this.value = initialValue;
        this.validator = validator;
        this.adapter = adapter;
        this.validate(initialValue);
    }

    public TextRule(GameRules.Type<TextRule> type, String initialValue) {
        this(type, initialValue, IGameruleValidator::alwaysTrue, Optional::of);
    }

    public String get() {
        return this.value;
    }

    public void set(String input, MinecraftServer server) throws UnsupportedOperationException {
        this.bump(input, server);
    }

    private void bump(String s, MinecraftServer server) {
        Optional<String> o;
        boolean b = this.validator.validate(s);
        if (!b && (o = this.adapter.adapt(s)).isPresent() && this.validator.validate(o.get())) {
            s = o.get();
            b = true;
        }
        if (b) {
            this.value = s;
            this.onChanged(server);
        }
    }

    private boolean set(String s, boolean adapt) {
        if (this.validator.validate(s)) {
            this.value = s;
            return true;
        }
        if (!adapt) {
            return false;
        }
        Optional<String> o = this.adapter.adapt(s);
        if (o.isEmpty() || !this.validator.validate(o.get())) {
            return false;
        }
        this.value = o.get();
        return true;
    }

    public boolean validate(String input) {
        return this.set(input, false);
    }

    protected void updateFromArgument(CommandContext<CommandSourceStack> context, String name) {
        String input = StringArgumentType.getString(context, (String)name);
        this.set(input, true);
    }

    protected void deserialize(String value) {
        this.set(value, true);
    }

    public String serialize() {
        return this.get();
    }

    public int getCommandResult() {
        return this.get().length();
    }

    public TextRule copy() {
        return new TextRule((GameRules.Type<TextRule>)this.type, this.get(), this.unruled_getValidator(), this.unruled_getAdapter());
    }

    protected TextRule getThis() {
        return this;
    }

    public void setValue(TextRule rule, @Nullable MinecraftServer server) {
        this.bump(rule.get(), server);
    }

    @Override
    public IGameruleValidator<String> unruled_getValidator() {
        return this.validator;
    }

    @Override
    public void unruled_setValidator(IGameruleValidator<String> validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    @Override
    public IGameruleAdapter<String> unruled_getAdapter() {
        return this.adapter;
    }

    @Override
    public void unruled_setAdapter(IGameruleAdapter<String> adapter) {
        this.adapter = Objects.requireNonNull(adapter);
    }

    public static class Builder
    extends RuleBuilder<TextRule, String> {
        public Builder(String initialValue) {
            super(StringArgumentType::string, Builder::acceptor, TextRule.class, initialValue);
        }

        @Override
        @NotNull
        protected TextRule ruleBuilder(GameRules.Type<TextRule> type) {
            return new TextRule(type, (String)this.initialValue, this.validator, this.adapter);
        }

        static void acceptor(GameRules.GameRuleTypeVisitor consumer, GameRules.Key<TextRule> key, GameRules.Type<TextRule> type) {
            ((IGameRulesVisitor)consumer).unruled_visitText(key, type);
        }
    }
}

