package mc.recraftors.unruled_api.mixin;

import mc.recraftors.unruled_api.rules.*;
import mc.recraftors.unruled_api.utils.IGameRulesProvider;
import mc.recraftors.unruled_api.utils.IGamerulesInitializer;
import net.minecraft.class_1928;
import net.minecraft.class_2300;
import net.minecraft.class_5455;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Mixin(class_1928.class)
public abstract class GameRulesMixin implements IGameRulesProvider, IGamerulesInitializer {
    @Shadow public abstract <T extends class_1928.class_4315<T>> T get(class_1928.class_4313<T> key);

    @Shadow @Final private Map<class_1928.class_4313<?>, class_1928.class_4315<?>> rules;

    @Override
    public float unruled_getFloat(class_1928.class_4313<FloatRule> key) {
        return this.get(key).get();
    }

    @Override
    public long unruled_getLong(class_1928.class_4313<LongRule> key) {
        return this.get(key).get();
    }

    @Override
    public double unruled_getDouble(class_1928.class_4313<DoubleRule> key) {
        return this.get(key).get();
    }

    @Override
    public <T extends Enum<T>> T unruled_getEnum(class_1928.class_4313<EnumRule<T>> key) {
        return this.get(key).get();
    }

    @Override
    public String unruled_getString(class_1928.class_4313<StringRule> key) {
        return this.get(key).get();
    }

    @Override
    public class_2300 unruled_getEntitySelector(class_1928.class_4313<EntitySelectorRule> key) {
        return this.get(key).get();
    }

    @Override
    public <T> T unruled_getRegistryEntry(class_1928.class_4313<RegistryEntryRule<T>> key) {
        return this.get(key).get();
    }

    @Override
    public String unruled_getText(class_1928.class_4313<TextRule> key) {
        return this.get(key).get();
    }

    @Override
    public Map<String, class_1928.class_4313<?>> unruled_getMatchingRules(Set<String> names) {
        return this.rules.keySet().stream()
                .filter(k -> names.contains(k.method_20771()))
                .collect(Collectors.toUnmodifiableMap(class_1928.class_4313::method_20771, k -> k));
    }

    @Override
    public void unruled_loadRegistryEntries(class_5455 registryManager) {
        this.rules.forEach((k, r) -> {
            if (!(r instanceof RegistryEntryRule<?> rr)) return;
            rr.provide(registryManager);
        });
    }
}
