package mc.recraftors.unruled_api.impl;

import mc.recraftors.unruled_api.utils.SimpleRegistryWrapperImpl;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import net.minecraft.registry.*;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class FullRegistryWrapperLookup implements class_7225.class_7874 {
    private final Map<class_5321<? extends class_2378<?>>, class_7225<?>> map;
    private final class_7699 featureSet;

    public FullRegistryWrapperLookup(class_7699 featureSet, class_7157 registryAccess) {
        this.featureSet = featureSet;
        map = Stream.concat(
                class_7923.field_41167.method_29722().stream()
                        .flatMap(e -> Stream.of(
                                new ImmutablePair<>(e.getKey(), e.getValue()),
                                new ImmutablePair<>(e.getKey(), registryAccess.method_46762(e.getKey()))
                        )),
                Stream.of(new ImmutablePair<>(class_7923.field_41167.method_46765(), class_7923.field_41167))
        ).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (i1, i2) -> i2));
    }

    @Override
    public Stream<class_5321<? extends class_2378<?>>> method_55282() {
        return map.keySet().stream();
    }

    @Override
    public <T> Optional<class_7225.class_7226<T>> method_46759(class_5321<? extends class_2378<? extends T>> key) {
        //noinspection unchecked
        return Optional.ofNullable(map.getOrDefault(key, null))
                .map(w -> new SimpleRegistryWrapperImpl<>((class_7225<? super T>) w, key))
                .map(w -> (class_7225.class_7226<T>) w);
    }

    public class_7157 toCommandRegAccessAccess() {
        return new class_7157() {
            @Override
            public class_7699 method_64226() {
                return FullRegistryWrapperLookup.this.featureSet;
            }

            @Override
            public Stream<class_5321<? extends class_2378<?>>> method_55282() {
                return FullRegistryWrapperLookup.this.method_55282();
            }

            @Override
            public <T> Optional<? extends class_7225.class_7226<T>> method_46759(class_5321<? extends class_2378<? extends T>> registryRef) {
                return FullRegistryWrapperLookup.this.method_46759(registryRef);
            }
        };
    }
}
