package mc.recraftors.unruled_api.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import mc.recraftors.unruled_api.utils.IGamerulesInitializer;
import net.minecraft.class_1928;
import net.minecraft.class_5268;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;

@Mixin(MinecraftServer.class)
public abstract class ServerMixin {
    @Shadow public abstract class_5455.class_6890 getRegistryManager();

    @Unique
    private class_1928 unruled_api$serverRules;

    @Inject(
            method = "createWorlds",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/registry/Registry;get(Lnet/minecraft/registry/RegistryKey;)Ljava/lang/Object;"
            )
    )
    private void unruled_initServerRules(
            CallbackInfo ci, @Local class_5268 properties
    ) {
        this.unruled_api$serverRules = properties.method_146();
        ((IGamerulesInitializer)this.unruled_api$serverRules).unruled_loadRegistryEntries(this.getRegistryManager());
    }

    @WrapMethod(method = "getGameRules")
    private class_1928 getServerRules(Operation<class_1928> original) {
        return this.unruled_api$serverRules;
    }

    @WrapMethod(method = "reloadResources")
    private CompletableFuture<Void> unruled_reloadRegistryRules(
            Collection<String> dataPacks, Operation<CompletableFuture<Void>> original
    ) {
        return original.call(dataPacks)
                .thenAccept(x -> ((IGamerulesInitializer)this.unruled_api$serverRules)
                        .unruled_loadRegistryEntries(this.getRegistryManager()));
    }
}
