package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameRulesVisitor;
import mc.recraftors.unruled_api.utils.IGameruleAdapter;
import mc.recraftors.unruled_api.utils.IGameruleValidator;
import net.minecraft.class_1928.class_4311;
import net.minecraft.class_1928.class_4313;
import net.minecraft.class_1928.class_4314;
import net.minecraft.class_1928.class_4315;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameRules.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.Optional;

/**
 * Technically functional text gamerule for rules beyond 128 characters long.
 * <p>
 * Warning: world creation menu not yet implemented (will appear as a useless button)
 */
public class TextRule extends class_4315<TextRule> implements GameruleAccessor<String> {
    private String value;
    private IGameruleValidator<String> validator;
    private IGameruleAdapter<String> adapter;

    public TextRule(class_4314<TextRule> type, String initialValue, IGameruleValidator<String> validator, IGameruleAdapter<String> adapter) {
        super(type);
        Objects.requireNonNull(initialValue);
        Objects.requireNonNull(validator);
        Objects.requireNonNull(adapter);
        this.value = initialValue;
        this.validator = validator;
        this.adapter = adapter;
        this.validate(initialValue);
    }

    public TextRule(class_4314<TextRule> type, String initialValue) {
        this(type, initialValue, IGameruleValidator::alwaysTrue, Optional::of);
    }

    public String get() {
        return this.value;
    }

    public void set(String input, MinecraftServer server) throws UnsupportedOperationException {
        this.bump(input, server);
    }

    private void bump(String s, MinecraftServer server) {
        boolean b = this.validator.validate(s);
        if (!b) {
            Optional<String> o = this.adapter.adapt(s);
            if (o.isPresent() && this.validator.validate(o.get())) {
                s = o.get();
                b = true;
            }
        }
        if (b) {
            this.value = s;
            this.method_20778(server);
        }
    }

    @SuppressWarnings("DuplicatedCode")
    private boolean set(String s, boolean adapt) {
        if (this.validator.validate(s)) {
            this.value = s;
            return true;
        }
        if (!adapt) return false;
        Optional<String> o = this.adapter.adapt(s);
        if (o.isEmpty() || !this.validator.validate(o.get())) return false;
        this.value = o.get();
        return true;
    }

    public boolean validate(String input) {
        return this.set(input, false);
    }

    @Override
    protected void method_20776(CommandContext<class_2168> context, String name) {
        String input = StringArgumentType.getString(context, name);
        this.set(input, true);
    }

    @Override
    protected void method_20777(String value) {
        this.set(value, true);
    }

    @Override
    public String method_20779() {
        return this.get();
    }

    @Override
    public int method_20781() {
        return this.get().length();
    }

    @Override
    public TextRule method_27338() {
        return new TextRule(this.field_19417, this.get(), this.unruled_getValidator(), this.unruled_getAdapter());
    }

    @Override
    protected TextRule method_20782() {
        return this;
    }

    @Override
    public void setValue(TextRule rule, @Nullable MinecraftServer server) {
        this.bump(rule.get(), server);
    }

    @Override
    public IGameruleValidator<String> unruled_getValidator() {
        return this.validator;
    }

    @Override
    public void unruled_setValidator(IGameruleValidator<String> validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    @Override
    public IGameruleAdapter<String> unruled_getAdapter() {
        return this.adapter;
    }

    @Override
    public void unruled_setAdapter(IGameruleAdapter<String> adapter) {
        this.adapter = Objects.requireNonNull(adapter);
    }

    public static class Builder extends RuleBuilder<TextRule, String> {
        public Builder(String initialValue) {
            super(StringArgumentType::string, Builder::acceptor, TextRule.class, initialValue);
        }

        @Override
        protected @NotNull TextRule ruleBuilder(class_4314<TextRule> type) {
            return new TextRule(type, super.initialValue, super.validator, super.adapter);
        }

        static void acceptor(class_4311 consumer, class_4313<TextRule> key, class_4314<TextRule> type) {
            ((IGameRulesVisitor)consumer).unruled_visitText(key, type);
        }
    }
}
