package mc.recraftors.unruled_api.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicLike;
import com.mojang.serialization.JsonOps;
import mc.recraftors.unruled_api.UnruledApi;
import net.minecraft.class_7157;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.text.Normalizer;
import java.util.Map;
import java.util.function.BiConsumer;

public final class Utils {
    public static final ThreadLocal<class_7157> registryAccessThreadLocal = new ThreadLocal<>();
    public static final ThreadLocal<Map<String, CommandAggregator>> aggregatorsMap = new ThreadLocal<>();

    public static <T, U> BiConsumer<T, U> empty() {
        return (t, u) -> {};
    }

    public static String enumNameCorrector(String s) {
        String r = s.trim();
        if (r.isEmpty()) throw new UnsupportedOperationException("Name cannot be empty");
        char c;
        while (!r.isEmpty() && !((c = r.charAt(0)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
            r = r.substring(1);
        }
        if (r.isEmpty()) throw new UnsupportedOperationException("Enum name must begin with a letter");
        r = Normalizer.normalize(r, Normalizer.Form.NFD).replaceAll("\\p{M}", "");
        int i = 0;
        while (i < r.length()) {
            if (!((c = r.charAt(i)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_')) {
                if (String.valueOf(c).isBlank()) {
                    r = r.substring(0, i) + '_' + r.substring(i + 1);
                    i++;
                } else {
                    r = r.substring(0, i) + r.substring(i + 1);
                }
            } else {
                i++;
            }
        }
        return r;
    }

    public static DynamicLike<?> loadDynamicFromJsonFile(String path) {
        try (InputStreamReader reader = new InputStreamReader(new FileInputStream(path))) {
            JsonElement element = JsonParser.parseReader(reader);
            return new Dynamic<>(JsonOps.INSTANCE, element);
        } catch (FileNotFoundException e) {
            // noop
        } catch (Exception e) {
            UnruledApi.LOGGER.warn("Could not parse file '{}' to Json", path, e);
        }
        return new Dynamic<>(JsonOps.INSTANCE, new JsonObject());
    }
}
