package mc.recraftors.unruled_api.widgets;


import com.google.common.collect.Lists;
import mc.recraftors.unruled_api.utils.ClientProvider;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_5235;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import java.util.List;

/**
 * Accessible shadow clone of the vanilla gamerule widget.
 * Allows for easy display of custom gamerule types.
 */
@Environment(EnvType.CLIENT)
public abstract class NamedRuleWidget<T extends class_339> extends class_5235.class_5240 {
    private final List<class_5481> name;
    protected final List<class_339> children;
    private final class_5235 screen;
    protected final T valueWidget;

    @SuppressWarnings("resource")
    protected NamedRuleWidget(List<class_5481> description, class_2561 name, class_5235 screen, T valueWidget) {
        super(description);
        this.children = Lists.newArrayList();
        this.name = ((ClientProvider)screen).unruled_getClient().field_1772.method_1728(name, 175);
        this.screen = screen;
        this.valueWidget = valueWidget;
    }

    public class_5235 getScreen() {
        return screen;
    }

    @Override
    public List<? extends class_364> method_25396() {
        return children;
    }

    @Override
    public List<? extends class_6379> method_37025() {
        return children;
    }

    @SuppressWarnings({"resource", "SuspiciousNameCombination"})
    protected void drawName(class_332 context, int x, int y) {
        if (this.name.size() == 1) {
            context.method_35720(((ClientProvider)screen).unruled_getClient().field_1772, this.name.get(0), y, (x + 5), -1);
        } else if (this.name.size() >= 2) {
            context.method_35720(((ClientProvider)screen).unruled_getClient().field_1772, this.name.get(0), y, x, -1);
            context.method_35720(((ClientProvider)screen).unruled_getClient().field_1772, this.name.get(1), y, (x + 10), -1);
        }
    }

    @Override
    public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
        this.drawName(context, method_73382(), method_73380());
        this.valueWidget.method_46421(method_73389() - 45);
        this.valueWidget.method_46419(method_73382());
        this.valueWidget.method_25394(context, mouseX, mouseY, deltaTicks);
    }
}
