/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.impl;

import java.util.Optional;
import mc.recraftors.unruled_api.impl.GameruleValidatorAdapter;

public class BoundedFloatRuleValidatorAdapter
extends GameruleValidatorAdapter<Float> {
    final float lower;
    final float upper;

    public BoundedFloatRuleValidatorAdapter(float lower, float upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("Upper bound cannot be inferior to lower bound");
        }
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public Optional<Float> adapt(Float f) {
        if (f.floatValue() < this.lower) {
            f = Float.valueOf(this.lower);
        } else if (f.floatValue() > this.upper) {
            f = Float.valueOf(this.upper);
        }
        return Optional.of(f);
    }

    @Override
    public boolean validate(Float f) {
        return this.lower <= f.floatValue() && f.floatValue() <= this.upper;
    }
}

