/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.impl;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mc.recraftors.unruled_api.utils.SimpleRegistryWrapperImpl;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlagSet;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class FullRegistryWrapperLookup
implements HolderLookup.Provider {
    private final Map<ResourceKey<? extends Registry<?>>, HolderLookup<?>> map;
    private final FeatureFlagSet featureSet;

    public FullRegistryWrapperLookup(FeatureFlagSet featureSet, CommandBuildContext registryAccess) {
        this.featureSet = featureSet;
        this.map = Stream.concat(BuiltInRegistries.REGISTRY.entrySet().stream().flatMap(e -> Stream.of(new ImmutablePair((Object)((ResourceKey)e.getKey()), (Object)((Registry)e.getValue())), new ImmutablePair((Object)((ResourceKey)e.getKey()), (Object)registryAccess.lookupOrThrow((ResourceKey)e.getKey())))), Stream.of(new ImmutablePair((Object)BuiltInRegistries.REGISTRY.key(), (Object)BuiltInRegistries.REGISTRY))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (i1, i2) -> i2));
    }

    public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
        return this.map.keySet().stream();
    }

    public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> key) {
        return Optional.ofNullable(this.map.getOrDefault(key, null)).map(w -> new SimpleRegistryWrapperImpl(w, key)).map(w -> w);
    }

    public CommandBuildContext toCommandRegAccessAccess() {
        return new CommandBuildContext(){

            public FeatureFlagSet enabledFeatures() {
                return FullRegistryWrapperLookup.this.featureSet;
            }

            public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
                return FullRegistryWrapperLookup.this.listRegistryKeys();
            }

            public <T> Optional<? extends HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryRef) {
                return FullRegistryWrapperLookup.this.lookup(registryRef);
            }
        };
    }
}

