/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mc.recraftors.unruled_api.rules.OverridesManager;
import mc.recraftors.unruled_api.utils.CommandAggregator;
import mc.recraftors.unruled_api.utils.EncapsulatedException;
import mc.recraftors.unruled_api.utils.IGameruleOverridesProvider;
import mc.recraftors.unruled_api.utils.LangFallbacks;
import mc.recraftors.unruled_api.utils.Utils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.GameRuleCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRuleCommand.class})
public abstract class GameRuleCommandMixin {
    @Inject(method={"register(Lcom/mojang/brigadier/CommandDispatcher;Lnet/minecraft/commands/CommandBuildContext;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/GameRules;visitGameRuleTypes(Lnet/minecraft/world/level/GameRules$GameRuleTypeVisitor;)V")})
    private static void setupOverridesCommand(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandRegistryAccess, CallbackInfo ci, @Local(ordinal=0) LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder, @Share(value="gamerule-overrides") LocalRef<LiteralArgumentBuilder<CommandSourceStack>> ref) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"gamerule-override").requires(source -> source.hasPermission(2));
        ref.set((Object)builder);
        Utils.aggregatorsMap.set(new HashMap());
        builder.executes(GameRuleCommandMixin::unruled_listOverridesSimple);
        builder.then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(GameRuleCommandMixin::unruled_listOverridesInWorld));
    }

    @WrapOperation(method={"register(Lcom/mojang/brigadier/CommandDispatcher;Lnet/minecraft/commands/CommandBuildContext;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/brigadier/CommandDispatcher;register(Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;)Lcom/mojang/brigadier/tree/LiteralCommandNode;")})
    private static LiteralCommandNode<CommandSourceStack> finallizeOverridesCommand(CommandDispatcher<CommandSourceStack> dispatcher, LiteralArgumentBuilder<CommandSourceStack> command, Operation<LiteralCommandNode<CommandSourceStack>> original, @Local(ordinal=0) LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder, @Share(value="gamerule-overrides") LocalRef<LiteralArgumentBuilder<CommandSourceStack>> ref) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)ref.get();
        Map<String, CommandAggregator> map = Utils.aggregatorsMap.get();
        LiteralArgumentBuilder get = Commands.literal((String)"get");
        LiteralArgumentBuilder set = Commands.literal((String)"set");
        LiteralArgumentBuilder unset = Commands.literal((String)"unset");
        LiteralArgumentBuilder inGet = Commands.literal((String)"get");
        LiteralArgumentBuilder inSet = Commands.literal((String)"set");
        LiteralArgumentBuilder inUnset = Commands.literal((String)"unset");
        if (map.containsKey("get")) {
            map.get("get").aggregate((ArgumentBuilder<CommandSourceStack, ?>)get);
        }
        if (map.containsKey("set")) {
            map.get("set").aggregate((ArgumentBuilder<CommandSourceStack, ?>)set);
        }
        if (map.containsKey("unset")) {
            map.get("unset").aggregate((ArgumentBuilder<CommandSourceStack, ?>)unset);
        }
        if (map.containsKey("in-get")) {
            map.get("in-get").aggregate((ArgumentBuilder<CommandSourceStack, ?>)inGet);
        }
        if (map.containsKey("in-set")) {
            map.get("in-set").aggregate((ArgumentBuilder<CommandSourceStack, ?>)inSet);
        }
        if (map.containsKey("in-unset")) {
            map.get("in-unset").aggregate((ArgumentBuilder<CommandSourceStack, ?>)inUnset);
        }
        for (GameRules.Category c : GameRules.Category.values()) {
            String k = c.name();
            if (map.containsKey(k)) {
                literalArgumentBuilder.then(map.get(k).aggregate((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal((String)k)));
            }
            if (map.containsKey("get-" + k)) {
                get.then(map.get("get-" + k).aggregate((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal((String)k)));
            }
            if (map.containsKey("set-" + k)) {
                set.then(map.get("set-" + k).aggregate((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal((String)k)));
            }
            if (map.containsKey("unset-" + k)) {
                unset.then(map.get("unset-" + k).aggregate((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal((String)k)));
            }
            if (map.containsKey("in-get-" + k)) {
                inGet.then(map.get("in-get-" + k).aggregate((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal((String)k)));
            }
            if (map.containsKey("in-set-" + k)) {
                inSet.then(map.get("in-set-" + k).aggregate((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal((String)k)));
            }
            if (!map.containsKey("in-unset-" + k)) continue;
            inUnset.then(map.get("in-unset-" + k).aggregate((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal((String)k)));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then((ArgumentBuilder)get)).then((ArgumentBuilder)set)).then((ArgumentBuilder)unset)).then(Commands.literal((String)"in").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then((ArgumentBuilder)inGet)).then((ArgumentBuilder)inSet)).then((ArgumentBuilder)inUnset))));
        Utils.aggregatorsMap.remove();
        return (LiteralCommandNode)original.call(new Object[]{dispatcher, command});
    }

    @WrapOperation(method={"setRule(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/world/level/GameRules$Key;)I"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/GameRules$Value;setFromArgument(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)V")})
    private static void executeSetGameRuleSetWrapper(GameRules.Value<?> instance, CommandContext<CommandSourceStack> context, String name, Operation<Void> original) throws Exception {
        try {
            original.call(new Object[]{instance, context, name});
        }
        catch (EncapsulatedException ex) {
            throw ex.exception;
        }
    }

    @Unique
    private static int unruled_listOverridesSimple(CommandContext<CommandSourceStack> context) {
        return GameRuleCommandMixin.unruled_listOverrides(context, ((CommandSourceStack)context.getSource()).getLevel());
    }

    @Unique
    private static int unruled_listOverridesInWorld(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return GameRuleCommandMixin.unruled_listOverrides(context, DimensionArgument.getDimension(context, (String)"dimension"));
    }

    @Unique
    private static int unruled_listOverrides(CommandContext<CommandSourceStack> context, ServerLevel world) {
        OverridesManager overrides = ((IGameruleOverridesProvider)world).unruled_getOverridesManager();
        Set<GameRules.Key<?>> set = overrides.getOverrides().getOverrides();
        StringBuilder sb = new StringBuilder();
        set.forEach(k -> sb.append("\n - ").append(k.getId()).append(": ").append(overrides.get(k).serialize()));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableWithFallback((String)"commands.gamerule_override.list", (String)LangFallbacks.OVERRIDE_LIST.format(world.dimension().location(), set.size(), sb.toString()), (Object[])new Object[]{world.dimension(), set.size(), sb.toString()}), false);
        return set.size();
    }
}

