/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.Map;
import mc.recraftors.unruled_api.rules.GameRulesOverrides;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.saveddata.SavedData;

public class OverridesManager
extends SavedData {
    private final GameRulesOverrides overrides;
    private final Map<String, String> rawMap;

    public static SavedData.Factory<OverridesManager> getPersistentStateType(GameRules rules, FeatureFlagSet featureSet) {
        return new SavedData.Factory(() -> new OverridesManager(rules, featureSet), (nbt, w) -> OverridesManager.fromNbt(nbt, rules, featureSet), DataFixTypes.valueOf((String)"GAMERULES"));
    }

    private OverridesManager(GameRules base, Map<String, String> rawMap, FeatureFlagSet featureSet) {
        this.overrides = new GameRulesOverrides(base, rawMap, featureSet);
        this.rawMap = rawMap;
    }

    private OverridesManager(GameRules base, FeatureFlagSet featureSet) {
        this(base, new HashMap<String, String>(), featureSet);
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.cache();
        this.rawMap.forEach((arg_0, arg_1) -> ((CompoundTag)nbt).putString(arg_0, arg_1));
        return nbt;
    }

    private static OverridesManager fromNbt(CompoundTag nbt, GameRules base, FeatureFlagSet featureSet) {
        HashMap<String, String> map = new HashMap<String, String>();
        nbt.getAllKeys().forEach(s -> {
            Tag e = nbt.get(s);
            if (!(e instanceof StringTag)) {
                return;
            }
            StringTag ns = (StringTag)e;
            map.put((String)s, ns.getAsString());
        });
        return new OverridesManager(base, map, featureSet);
    }

    public boolean isDirty() {
        this.cache();
        return super.isDirty();
    }

    public <T extends GameRules.Value<T>> boolean hasOverride(GameRules.Key<T> key) {
        return this.overrides.hasOverride(key);
    }

    public <T extends GameRules.Value<T>> boolean override(GameRules.Key<T> key, CommandContext<CommandSourceStack> context) {
        if (this.overrides.override(key, context)) {
            this.setDirty();
            return true;
        }
        return false;
    }

    public <T extends GameRules.Value<T>> boolean removeOverride(GameRules.Key<T> key) {
        if (this.overrides.removeOverride(key)) {
            this.setDirty();
            this.rawMap.remove(key.getId());
            return true;
        }
        return false;
    }

    public <T extends GameRules.Value<T>> T get(GameRules.Key<T> key) {
        return this.overrides.getRule(key);
    }

    private void cache() {
        this.overrides.getOverrides().forEach(k -> {
            String s = k.getId();
            String v = this.overrides.getRule(k).serialize();
            if (!this.rawMap.getOrDefault(s, "").equals(v)) {
                this.rawMap.put(s, v);
            }
        });
    }

    public boolean isEmpty() {
        return this.overrides == null || this.overrides.isEmpty();
    }

    public GameRulesOverrides getOverrides() {
        return this.overrides;
    }
}

