package mc.recraftors.unruled_api.mixin;

import mc.recraftors.unruled_api.utils.Utils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1928;
import net.minecraft.class_5321;
import net.minecraft.class_7145;
import net.minecraft.class_7193;
import net.minecraft.class_8100;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalLong;

@Environment(EnvType.CLIENT)
@Mixin(class_8100.class)
public abstract class WorldCreatorMixin {
    @Shadow private class_1928 gameRules;

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    @Inject(method = "<init>", at = @At("TAIL"))
    private void unruled_loadDefaultRules(
            Path savesDirectory, class_7193 generatorOptionsHolder,
            Optional<class_5321<class_7145>> defaultWorldType, OptionalLong seed, CallbackInfo ci
    ) {
        ((GameRulesInvoker)this.gameRules).invokeLoad(
                Utils.loadDynamicFromJsonFile("config/default_gamerules.json"));
    }
}
