package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.context.CommandContext;
import mc.recraftors.unruled_api.UnruledApi;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameRulesProvider;
import mc.recraftors.unruled_api.utils.ServerBoundAccessor;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_7699;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class GameRulesOverrides extends class_1928 {
    private final class_1928 base;
    private final Map<class_1928.class_4313<?>, class_1928.class_4315<?>> overrides;

    public GameRulesOverrides(class_1928 base, Map<String, String> map, class_7699 featureSet) {
        super(featureSet);
        this.base = base;
        this.overrides = new HashMap<>();
        Map<String, class_4313<?>> keyMap = ((IGameRulesProvider) base).unruled_getMatchingRules(map.keySet());
        keyMap.forEach((k, v) -> {
            String s = map.get(k);
            try {
                class_4315<?> rule = base.method_20746(v);
                if (!((ServerBoundAccessor)rule).unruled_isServerBound()) {
                    this.overrides.put(v, ((GameruleAccessor<?>) rule.method_27338()).unruled_setValue(s));
                }
            } catch (Exception ex) {
                UnruledApi.LOGGER.warn("Unable to deserialize override for {} from {}", k, s);
            }
        });
    }

    public boolean isEmpty() {
        return this.overrides.isEmpty();
    }

    public <T extends class_4315<T>> boolean hasOverride(class_4313<T> key) {
        return this.overrides.containsKey(key);
    }

    public <T extends class_4315<T>> boolean override(class_4313<T> key, CommandContext<class_2168> context) {
        if (!this.overrides.containsKey(key)) {
            T baseRule = this.base.method_20746(key);
            if (((ServerBoundAccessor)baseRule).unruled_isServerBound()) return false;
            this.overrides.put(key, baseRule.method_27338());
        }
        this.overrides.get(key).method_20780(context, "value");
        return true;
    }

    public <T extends class_4315<T>> boolean removeOverride(class_4313<T> key) {
        if (this.hasOverride(key)) {
            this.overrides.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public <T extends class_4315<T>> T method_20746(class_4313<T> key) {
        //noinspection unchecked
        return Optional.ofNullable((T) this.overrides.get(key))
                .orElseGet(() -> this.base.method_20746(key));
    }

    public Set<class_1928.class_4313<?>> getOverrides() {
        return this.overrides.keySet();
    }
}
