package mc.recraftors.unruled_api.widgets;


import com.google.common.collect.Lists;
import mc.recraftors.unruled_api.utils.ClientProvider;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_5235;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import java.util.List;

/**
 * Accessible shadow clone of the vanilla gamerule widget.
 * Allows for easy display of custom gamerule types.
 */
@Environment(EnvType.CLIENT)
public abstract class NamedRuleWidget extends class_5235.class_5240 {
    private final List<class_5481> name;
    protected final List<class_339> children;
    private final class_5235 screen;

    @SuppressWarnings("resource")
    protected NamedRuleWidget(List<class_5481> description, class_2561 name, class_5235 screen) {
        super(description);
        this.children = Lists.newArrayList();
        this.name = ((ClientProvider)screen).unruled_getClient().field_1772.method_1728(name, 175);
        this.screen = screen;
    }

    public class_5235 getScreen() {
        return screen;
    }

    @Override
    public List<? extends class_364> method_25396() {
        return children;
    }

    @Override
    public List<? extends class_6379> method_37025() {
        return children;
    }

    @SuppressWarnings({"resource", "SuspiciousNameCombination"})
    protected void drawName(class_332 context, int x, int y) {
        if (this.name.size() == 1) {
            context.method_51430(((ClientProvider)screen).unruled_getClient().field_1772, this.name.get(0), y, (x + 5), 0xFFFFFF, false);
        } else if (this.name.size() >= 2) {
            context.method_51430(((ClientProvider)screen).unruled_getClient().field_1772, this.name.get(0), y, x, 0xFFFFFF, false);
            context.method_51430(((ClientProvider)screen).unruled_getClient().field_1772, this.name.get(1), y, (x + 10), 0xFFFFFF, false);
        }
    }
}
