/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.mixin;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import java.util.function.Function;
import mc.recraftors.unruled_api.mixin.GameruleCommandInvoker;
import mc.recraftors.unruled_api.rules.OverridesManager;
import mc.recraftors.unruled_api.utils.CommandAggregator;
import mc.recraftors.unruled_api.utils.IGameruleOverridesProvider;
import mc.recraftors.unruled_api.utils.LangFallbacks;
import mc.recraftors.unruled_api.utils.ServerBoundAccessor;
import mc.recraftors.unruled_api.utils.Utils;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraft/server/command/GameRuleCommand$1"})
public abstract class GameruleCommandVisitorMixin {
    @Shadow
    @Final
    LiteralArgumentBuilder<class_2168> field_19419;

    @Inject(method={"visit"}, at={@At(value="TAIL")})
    private <T extends class_1928.class_4315<T>> void setupOverridesSubArgs(class_1928.class_4313<T> key, class_1928.class_4314<T> type, CallbackInfo ci) {
        String k = key.method_27335().name();
        Map<String, CommandAggregator> map = Utils.aggregatorsMap.get();
        if (map == null) {
            return;
        }
        Function<String, CommandAggregator> builder = s -> new CommandAggregator();
        map.computeIfAbsent(k, builder).add(((LiteralArgumentBuilder)class_2170.method_9247((String)key.method_20771()).executes(context -> GameruleCommandInvoker.callExecuteQuery((class_2168)context.getSource(), key))).then(type.method_20775("value").executes(context -> GameruleCommandInvoker.callExecuteSet((CommandContext<class_2168>)context, key))));
        if (((ServerBoundAccessor)type).unruled_isServerBound()) {
            return;
        }
        LiteralArgumentBuilder get = (LiteralArgumentBuilder)class_2170.method_9247((String)key.method_20771()).executes(c -> GameruleCommandVisitorMixin.unruled_queryOverrideSimple((CommandContext<class_2168>)c, key));
        map.computeIfAbsent("get", builder).add((ArgumentBuilder<class_2168, ?>)get);
        map.computeIfAbsent("get-" + k, builder).add((ArgumentBuilder<class_2168, ?>)get);
        LiteralArgumentBuilder set = (LiteralArgumentBuilder)class_2170.method_9247((String)key.method_20771()).then(type.method_20775("value").executes(c -> GameruleCommandVisitorMixin.unruled_setOverrideSimple((CommandContext<class_2168>)c, key)));
        map.computeIfAbsent("set", builder).add((ArgumentBuilder<class_2168, ?>)set);
        map.computeIfAbsent("set-" + k, builder).add((ArgumentBuilder<class_2168, ?>)set);
        LiteralArgumentBuilder unset = (LiteralArgumentBuilder)class_2170.method_9247((String)key.method_20771()).executes(c -> GameruleCommandVisitorMixin.unruled_unsetOverrideSimple((CommandContext<class_2168>)c, key));
        map.computeIfAbsent("unset", builder).add((ArgumentBuilder<class_2168, ?>)unset);
        map.computeIfAbsent("unset-" + k, builder).add((ArgumentBuilder<class_2168, ?>)unset);
        LiteralArgumentBuilder inGet = (LiteralArgumentBuilder)class_2170.method_9247((String)key.method_20771()).executes(c -> GameruleCommandVisitorMixin.unruled_queryOverrideInWorld((CommandContext<class_2168>)c, key));
        map.computeIfAbsent("in-get", builder).add((ArgumentBuilder<class_2168, ?>)inGet);
        map.computeIfAbsent("in-get-" + k, builder).add((ArgumentBuilder<class_2168, ?>)inGet);
        LiteralArgumentBuilder inSet = (LiteralArgumentBuilder)class_2170.method_9247((String)key.method_20771()).then(type.method_20775("value").executes(c -> GameruleCommandVisitorMixin.unruled_setOverrideInWorld((CommandContext<class_2168>)c, key)));
        map.computeIfAbsent("in-set", builder).add((ArgumentBuilder<class_2168, ?>)inSet);
        map.computeIfAbsent("in-set-" + k, builder).add((ArgumentBuilder<class_2168, ?>)inSet);
        LiteralArgumentBuilder inUnset = (LiteralArgumentBuilder)class_2170.method_9247((String)key.method_20771()).executes(c -> GameruleCommandVisitorMixin.unruled_unsetOverrideInWorld((CommandContext<class_2168>)c, key));
        map.computeIfAbsent("in-unset", builder).add((ArgumentBuilder<class_2168, ?>)inUnset);
        map.computeIfAbsent("in-unset-" + k, builder).add((ArgumentBuilder<class_2168, ?>)inUnset);
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_queryOverrideSimple(CommandContext<class_2168> context, class_1928.class_4313<T> key) {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        return GameruleCommandVisitorMixin.unruled_queryOverride(context, key, world);
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_queryOverrideInWorld(CommandContext<class_2168> context, class_1928.class_4313<T> key) throws CommandSyntaxException {
        return GameruleCommandVisitorMixin.unruled_queryOverride(context, key, class_2181.method_9289(context, (String)"dimension"));
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_setOverrideSimple(CommandContext<class_2168> context, class_1928.class_4313<T> key) {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        return GameruleCommandVisitorMixin.unruled_setOverride(context, key, world);
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_setOverrideInWorld(CommandContext<class_2168> context, class_1928.class_4313<T> key) throws CommandSyntaxException {
        return GameruleCommandVisitorMixin.unruled_setOverride(context, key, class_2181.method_9289(context, (String)"dimension"));
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_unsetOverrideSimple(CommandContext<class_2168> context, class_1928.class_4313<T> key) {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        return GameruleCommandVisitorMixin.unruled_unsetOverride(context, key, world);
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_unsetOverrideInWorld(CommandContext<class_2168> context, class_1928.class_4313<T> key) throws CommandSyntaxException {
        return GameruleCommandVisitorMixin.unruled_unsetOverride(context, key, class_2181.method_9289(context, (String)"dimension"));
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_queryOverride(CommandContext<class_2168> context, class_1928.class_4313<T> key, class_3218 world) {
        OverridesManager manager = ((IGameruleOverridesProvider)world).unruled_getOverridesManager();
        String keyName = key.method_20771();
        class_2960 worldId = world.method_27983().method_29177();
        if (!manager.hasOverride(key)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"commands.gamerule_override.none", (String)LangFallbacks.OVERRIDE_NONE.format(keyName, worldId), (Object[])new Object[]{keyName, worldId.toString()}), false);
            return 0;
        }
        Object rule = manager.get(key);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"commands.gamerule_override.query", (String)LangFallbacks.OVERRIDE_QUERY.format(keyName, worldId, rule.toString()), (Object[])new Object[]{keyName, worldId.toString(), rule.toString()}), false);
        return rule.method_20781();
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_setOverride(CommandContext<class_2168> context, class_1928.class_4313<T> key, class_3218 world) {
        OverridesManager manager = ((IGameruleOverridesProvider)world).unruled_getOverridesManager();
        String keyName = key.method_20771();
        class_2960 worldId = world.method_27983().method_29177();
        boolean b = manager.override(key, context);
        if (!b) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"commands.gamerule_override.server_bound", (String)LangFallbacks.OVERRIDE_SB.format(keyName), (Object[])new Object[]{keyName}), false);
            return ((class_2168)context.getSource()).method_9211().method_3767().method_20746(key).method_20781();
        }
        Object rule = manager.get(key);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"commands.gamerule_override.set", (String)LangFallbacks.OVERRIDE_SET.format(keyName, worldId, rule.toString()), (Object[])new Object[]{keyName, worldId.toString(), rule.toString()}), true);
        return rule.method_20781();
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_unsetOverride(CommandContext<class_2168> context, class_1928.class_4313<T> key, class_3218 world) {
        OverridesManager manager = ((IGameruleOverridesProvider)world).unruled_getOverridesManager();
        String keyName = key.method_20771();
        class_2960 worldId = world.method_27983().method_29177();
        boolean b = manager.removeOverride(key);
        String tr = "command.gamerule_override." + (b ? "unset" : "none");
        LangFallbacks fb = b ? LangFallbacks.OVERRIDE_UNSET : LangFallbacks.OVERRIDE_NONE;
        T rule = manager.get(key);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)tr, (String)fb.format(keyName, worldId), (Object[])new Object[]{keyName, worldId}), true);
        return rule.method_20781();
    }
}

