/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.DSL;
import java.util.function.BiConsumer;
import mc.recraftors.unruled_api.rules.DoubleRule;
import mc.recraftors.unruled_api.rules.EntitySelectorRule;
import mc.recraftors.unruled_api.rules.EnumRule;
import mc.recraftors.unruled_api.rules.FloatRule;
import mc.recraftors.unruled_api.rules.LongRule;
import mc.recraftors.unruled_api.rules.RegistryEntryRule;
import mc.recraftors.unruled_api.rules.RuleBuilder;
import mc.recraftors.unruled_api.rules.StringRule;
import mc.recraftors.unruled_api.rules.TextRule;
import mc.recraftors.unruled_api.utils.EncapsulatedException;
import mc.recraftors.unruled_api.utils.IGameRulesProvider;
import mc.recraftors.unruled_api.utils.ServerBoundAccessor;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.GameRules;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class UnruledApi {
    public static final String MOD_ID = "unruled_api";
    public static final Logger LOGGER = LogManager.getLogger((String)"unruled_api");
    public static final DynamicCommandExceptionType INVALID_INT = new DynamicCommandExceptionType(v -> new LiteralMessage("Invalid integer '" + String.valueOf(v) + "'"));
    public static final DSL.TypeReference GAMERULES_TYPE = References.reference((String)"gamerules");

    private static int strLen(String s, int i) {
        return Math.max(i, (int)Math.ceil((double)s.length() / 8.0) * 8);
    }

    public static <T extends GameRules.Value<T>> GameRules.Key<T> register(String name, GameRules.Category category, GameRules.Type<T> type) {
        return GameRules.register((String)name, (GameRules.Category)category, type);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static GameRules.Type<GameRules.BooleanValue> createBoolean(boolean initialValue, BiConsumer<MinecraftServer, GameRules.BooleanValue> changeCallback) {
        return GameRules.BooleanValue.create((boolean)initialValue, changeCallback);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static GameRules.Type<GameRules.BooleanValue> createBoolean(boolean initialValue, BiConsumer<MinecraftServer, GameRules.BooleanValue> changeCallback, boolean serverBound) {
        GameRules.Type type = GameRules.BooleanValue.create((boolean)initialValue, changeCallback);
        ((ServerBoundAccessor)type).unruled_setServerBound(serverBound);
        return type;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static GameRules.Type<GameRules.BooleanValue> createBoolean(boolean initialValue) {
        return GameRules.BooleanValue.create((boolean)initialValue);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static GameRules.Type<GameRules.BooleanValue> createBoolean(boolean initialValue, boolean serverBound) {
        GameRules.Type type = GameRules.BooleanValue.create((boolean)initialValue);
        ((ServerBoundAccessor)type).unruled_setServerBound(serverBound);
        return type;
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static GameRules.Key<GameRules.BooleanValue> registerBoolean(String name, GameRules.Category category, boolean initialValue, BiConsumer<MinecraftServer, GameRules.BooleanValue> changeCallback) {
        return UnruledApi.register(name, category, UnruledApi.createBoolean(initialValue, changeCallback));
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static GameRules.Key<GameRules.BooleanValue> registerBoolean(String name, GameRules.Category category, boolean initialValue, BiConsumer<MinecraftServer, GameRules.BooleanValue> changeCallback, boolean serverBound) {
        return UnruledApi.register(name, category, UnruledApi.createBoolean(initialValue, changeCallback, serverBound));
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static GameRules.Key<GameRules.BooleanValue> registerBoolean(String name, GameRules.Category category, boolean initialValue) {
        return UnruledApi.register(name, category, UnruledApi.createBoolean(initialValue));
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static GameRules.Key<GameRules.BooleanValue> registerBoolean(String name, GameRules.Category category, boolean initialValue, boolean serverBound) {
        return UnruledApi.register(name, category, UnruledApi.createBoolean(initialValue, serverBound));
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static GameRules.Type<GameRules.IntegerValue> createInt(int initialValue, BiConsumer<MinecraftServer, GameRules.IntegerValue> changeCallback) {
        return GameRules.IntegerValue.create((int)initialValue, changeCallback);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static GameRules.Type<GameRules.IntegerValue> createInt(int initialValue) {
        return GameRules.IntegerValue.create((int)initialValue);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static GameRules.Key<GameRules.IntegerValue> registerInt(String name, GameRules.Category category, int initialValue, BiConsumer<MinecraftServer, GameRules.IntegerValue> changeCallback) {
        return UnruledApi.register(name, category, UnruledApi.createInt(initialValue, changeCallback));
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static GameRules.Key<GameRules.IntegerValue> registerInt(String name, GameRules.Category category, int initialValue) {
        return UnruledApi.register(name, category, UnruledApi.createInt(initialValue));
    }

    public static RuleBuilder<GameRules.IntegerValue, Integer> intRuleBuilder(int initialValue) {
        return new RuleBuilder.IntRuleBuilder(initialValue);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static GameRules.Key<DoubleRule> registerDoubleRule(String name, GameRules.Category category, double initialValue) {
        return UnruledApi.doubleRuleBuilder(initialValue).register(name, category);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static GameRules.Key<EntitySelectorRule> registerEntitySelectorRule(String name, GameRules.Category category, String initialValue) {
        return UnruledApi.entitySelectorRuleBuilder(initialValue).register(name, category);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <T extends Enum<T>> GameRules.Key<EnumRule<T>> registerEnumRule(String name, GameRules.Category category, Class<T> enumClass, T initialValue) {
        return UnruledApi.enumRuleBuilder(enumClass, initialValue).register(name, category);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static GameRules.Key<FloatRule> registerFloatRule(String name, GameRules.Category category, float initialValue) {
        return UnruledApi.floatRuleBuilder(initialValue).register(name, category);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static GameRules.Key<LongRule> registerLongRule(String name, GameRules.Category category, long initialValue) {
        return UnruledApi.longRuleBuilder(initialValue).register(name, category);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <T> GameRules.Key<RegistryEntryRule<T>> registerRegistryEntryRule(String name, GameRules.Category category, Registry<T> registry, T initialValue) {
        return UnruledApi.registryEntryRuleBuilder(registry, initialValue).register(name, category);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static GameRules.Key<StringRule> registerStringRule(String name, GameRules.Category category, String initialValue, int maxLength) {
        return UnruledApi.stringRuleBuilder(initialValue, maxLength).register(name, category);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static GameRules.Key<TextRule> registerTextRule(String name, GameRules.Category category, String initialValue) {
        return UnruledApi.textRuleBuilder(initialValue).register(name, category);
    }

    public static DoubleRule.Builder doubleRuleBuilder(double initialValue) {
        return new DoubleRule.Builder(initialValue);
    }

    public static EntitySelectorRule.Builder entitySelectorRuleBuilder(String initialValue) throws EncapsulatedException {
        return new EntitySelectorRule.Builder(initialValue);
    }

    public static <T extends Enum<T>> EnumRule.Builder<T> enumRuleBuilder(Class<T> enumClass, T initialValue) {
        return new EnumRule.Builder<T>(enumClass, initialValue);
    }

    public static FloatRule.Builder floatRuleBuilder(float initialValue) {
        return new FloatRule.Builder(initialValue);
    }

    public static LongRule.Builder longRuleBuilder(long initialValue) {
        return new LongRule.Builder(initialValue);
    }

    public static <T> RegistryEntryRule.Builder<T> registryEntryRuleBuilder(Registry<T> registry, T initialValue) {
        return new RegistryEntryRule.Builder<T>(registry, initialValue);
    }

    public static <T> RegistryEntryRule.Builder<T> registryEntryRuleBuilder(ResourceKey<? extends Registry<T>> key, ResourceLocation valueId) {
        return new RegistryEntryRule.Builder(key, valueId);
    }

    public static StringRule.Builder stringRuleBuilder(String initialValue, int maxLength) throws UnsupportedOperationException {
        return new StringRule.Builder(initialValue, maxLength);
    }

    public static TextRule.Builder textRuleBuilder(String initialValue) {
        return new TextRule.Builder(initialValue);
    }

    public static boolean getBoolean(GameRules gameRules, GameRules.Key<GameRules.BooleanValue> key) {
        return gameRules.getBoolean(key);
    }

    public static int getInt(GameRules gamerules, GameRules.Key<GameRules.IntegerValue> key) {
        return gamerules.getInt(key);
    }

    public static long getLong(GameRules gameRules, GameRules.Key<LongRule> key) {
        return ((IGameRulesProvider)gameRules).unruled_getLong(key);
    }

    public static float getFloat(GameRules gameRules, GameRules.Key<FloatRule> key) {
        return ((IGameRulesProvider)gameRules).unruled_getFloat(key);
    }

    public static double getDouble(GameRules gameRules, GameRules.Key<DoubleRule> key) {
        return ((IGameRulesProvider)gameRules).unruled_getDouble(key);
    }

    public static <T extends Enum<T>> T getEnum(GameRules gameRules, GameRules.Key<EnumRule<T>> key) {
        return ((IGameRulesProvider)gameRules).unruled_getEnum(key);
    }

    public static String getString(GameRules gameRules, GameRules.Key<StringRule> key) {
        return ((IGameRulesProvider)gameRules).unruled_getString(key);
    }

    public static String getText(GameRules gameRules, GameRules.Key<TextRule> key) {
        return ((IGameRulesProvider)gameRules).unruled_getText(key);
    }

    public static EntitySelector getEntitySelector(GameRules gameRules, GameRules.Key<EntitySelectorRule> key) {
        return ((IGameRulesProvider)gameRules).unruled_getEntitySelector(key);
    }

    public static <T> T getRegistryEntry(GameRules gameRules, GameRules.Key<RegistryEntryRule<T>> key) {
        return ((IGameRulesProvider)gameRules).unruled_getRegistryEntry(key);
    }
}

