/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.impl;

import java.util.Optional;
import mc.recraftors.unruled_api.impl.GameruleValidatorAdapter;

public class BoundedIntRuleValidatorAdapter
extends GameruleValidatorAdapter<Integer> {
    final int lower;
    final int upper;

    public BoundedIntRuleValidatorAdapter(int lower, int upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("Upper bound cannot be inferior to lower bound");
        }
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public Optional<Integer> adapt(Integer integer) {
        return Optional.of(Math.min(this.upper, Math.max(this.lower, integer)));
    }

    @Override
    public boolean validate(Integer integer) {
        return this.lower <= integer && this.upper >= integer;
    }
}

