/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.widgets;

import java.util.List;
import mc.recraftors.unruled_api.rules.EnumRule;
import mc.recraftors.unruled_api.widgets.NamedRuleWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.worldselection.EditGameRulesScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class EnumRuleWidget<T extends Enum<T>>
extends NamedRuleWidget {
    private final CycleButton<T> valuesWidget;

    public EnumRuleWidget(Component name, List<FormattedCharSequence> description, String ruleName, EnumRule<T> rule, EditGameRulesScreen screen) {
        super(description, name, screen);
        this.valuesWidget = CycleButton.builder(t -> Component.nullToEmpty((String)t.name())).withValues((Object[])rule.values()).displayOnlyValue().withCustomNarration(button -> button.createDefaultNarrationMessage().append("\n").append(ruleName)).create(10, 5, 44, 20, name, (button, value) -> rule.set(value, null));
        this.children.add(this.valuesWidget);
    }

    public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.drawName(context, y, x);
        this.valuesWidget.setX(x + entryWidth - 45);
        this.valuesWidget.setY(y);
        this.valuesWidget.render(context, mouseX, mouseY, tickDelta);
    }
}

