/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import java.util.Optional;
import mc.recraftors.unruled_api.UnruledApi;
import mc.recraftors.unruled_api.rules.RuleBuilder;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameRulesVisitor;
import mc.recraftors.unruled_api.utils.IGameruleAdapter;
import mc.recraftors.unruled_api.utils.IGameruleValidator;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongRule
extends class_1928.class_4315<LongRule>
implements GameruleAccessor<Long> {
    private long value;
    private IGameruleValidator<Long> validator;
    private IGameruleAdapter<Long> adapter;

    public LongRule(class_1928.class_4314<LongRule> type, long initialValue, IGameruleValidator<Long> validator, IGameruleAdapter<Long> adapter) {
        super(type);
        Objects.requireNonNull(validator);
        Objects.requireNonNull(adapter);
        this.value = initialValue;
        this.validator = validator;
        this.adapter = adapter;
    }

    public LongRule(class_1928.class_4314<LongRule> type, long initialValue) {
        this(type, initialValue, IGameruleValidator::alwaysTrue, Optional::of);
    }

    public long get() {
        return this.value;
    }

    public void set(long value, MinecraftServer server) {
        this.bump(value, server);
    }

    private void bump(long value, MinecraftServer server) {
        boolean b = false;
        if (this.validator.validate(value)) {
            b = true;
        } else {
            Optional<Long> o = this.adapter.adapt(value);
            if (o.isPresent() && this.validator.validate(o.get())) {
                value = o.get();
                b = true;
            }
        }
        if (b) {
            this.value = value;
            this.method_20778(server);
        }
    }

    private void set(long f) {
        if (this.validator.validate(f)) {
            this.value = f;
            return;
        }
        Optional<Long> o = this.adapter.adapt(f);
        if (o.isEmpty() || !this.validator.validate(o.get())) {
            return;
        }
        this.value = o.get();
    }

    public boolean validate(String input) {
        try {
            long l = Long.parseLong(input);
            if (this.validator.validate(l)) {
                this.value = l;
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static long parseLong(String input) {
        if (!input.isEmpty()) {
            try {
                return Long.parseLong(input);
            }
            catch (NumberFormatException e) {
                UnruledApi.LOGGER.warn("Failed to parse long {}", (Object)input);
            }
        }
        return 0L;
    }

    protected void method_20776(CommandContext<class_2168> context, String name) {
        long l = LongArgumentType.getLong(context, (String)name);
        this.set(l);
    }

    protected void method_20777(String value) {
        long l = LongRule.parseLong(value);
        this.set(l);
    }

    public String method_20779() {
        return Long.toString(this.value);
    }

    public int method_20781() {
        return (int)this.value;
    }

    protected LongRule getThis() {
        return this;
    }

    public LongRule copy() {
        return new LongRule((class_1928.class_4314<LongRule>)this.field_19417, this.value, this.validator, this.adapter);
    }

    public void setValue(LongRule rule, @Nullable MinecraftServer server) {
        this.bump(rule.get(), server);
    }

    @Override
    public IGameruleValidator<Long> unruled_getValidator() {
        return this.validator;
    }

    @Override
    public void unruled_setValidator(IGameruleValidator<Long> validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    @Override
    public IGameruleAdapter<Long> unruled_getAdapter() {
        return this.adapter;
    }

    @Override
    public void unruled_setAdapter(IGameruleAdapter<Long> adapter) {
        this.adapter = Objects.requireNonNull(adapter);
    }

    public static class Builder
    extends RuleBuilder<LongRule, Long> {
        public Builder(long initialValue) {
            super(LongArgumentType::longArg, Builder::acceptor, LongRule.class, initialValue);
        }

        @Override
        @NotNull
        protected LongRule ruleBuilder(class_1928.class_4314<LongRule> type) {
            return new LongRule(type, (Long)this.initialValue, this.validator, this.adapter);
        }

        static void acceptor(class_1928.class_4311 consumer, class_1928.class_4313<LongRule> key, class_1928.class_4314<LongRule> type) {
            ((IGameRulesVisitor)consumer).unruled_visitLong(key, type);
        }
    }
}

