/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.Objects;
import java.util.Optional;
import mc.recraftors.unruled_api.rules.RuleBuilder;
import mc.recraftors.unruled_api.utils.EncapsulatedException;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameRulesVisitor;
import mc.recraftors.unruled_api.utils.IGameruleAdapter;
import mc.recraftors.unruled_api.utils.IGameruleValidator;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringRule
extends class_1928.class_4315<StringRule>
implements GameruleAccessor<String> {
    public static final Dynamic2CommandExceptionType SIZE_TOO_LONG = new Dynamic2CommandExceptionType((a, b) -> new LiteralMessage("Input must be at most " + String.valueOf(a) + " long, found " + String.valueOf(b)));
    private final int maxLength;
    private String value;
    private IGameruleValidator<String> validator;
    private IGameruleAdapter<String> adapter;

    public StringRule(class_1928.class_4314<StringRule> type, int maxLength, String initialValue, IGameruleValidator<String> validator, IGameruleAdapter<String> adapter) {
        super(type);
        Objects.requireNonNull(initialValue);
        Objects.requireNonNull(validator);
        Objects.requireNonNull(adapter);
        if (maxLength <= 0) {
            throw new UnsupportedOperationException("String rule size cannot be negative or null");
        }
        if (maxLength > 128) {
            throw new UnsupportedOperationException("String rule size cannot be greater than 128. Use a Text rule for that.");
        }
        this.maxLength = maxLength;
        if (initialValue.length() > this.getMaxLength()) {
            throw new UnsupportedOperationException("Default value cannot breach max length");
        }
        this.value = initialValue;
        this.validator = validator;
        this.adapter = adapter;
    }

    public StringRule(class_1928.class_4314<StringRule> type, int maxLength, String initialValue) {
        this(type, maxLength, initialValue, IGameruleValidator::alwaysTrue, Optional::of);
    }

    public String get() {
        return this.value;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    protected boolean breaksMaxLength(String input) {
        return input.length() > this.getMaxLength();
    }

    public void set(String input, MinecraftServer server) throws UnsupportedOperationException {
        this.bump(input, server, true);
    }

    private void bump(String s, MinecraftServer server, boolean thr) {
        Optional<String> o;
        boolean b;
        if (this.breaksMaxLength(s)) {
            if (thr) {
                throw new UnsupportedOperationException();
            }
            s = s.substring(0, this.getMaxLength());
        }
        if (!(b = this.validator.validate(s)) && (o = this.adapter.adapt(s)).isPresent() && this.validator.validate(o.get())) {
            s = o.get();
            b = true;
        }
        if (b) {
            this.value = s;
            this.method_20778(server);
        }
    }

    private boolean set(String s, boolean thr, boolean trc, boolean adapt) {
        if (this.breaksMaxLength(s)) {
            if (thr) {
                throw new EncapsulatedException("too long", (Exception)((Object)SIZE_TOO_LONG.create((Object)this.getMaxLength(), (Object)s.length())));
            }
            if (trc) {
                s = s.substring(0, this.getMaxLength());
            } else {
                return false;
            }
        }
        if (this.validator.validate(s)) {
            this.value = s;
            return true;
        }
        if (!adapt) {
            return false;
        }
        Optional<String> o = this.adapter.adapt(s);
        if (o.isEmpty() || !this.validator.validate(o.get())) {
            return false;
        }
        this.value = o.get();
        return true;
    }

    public boolean validate(String input) {
        return this.set(input, false, false, false);
    }

    protected void method_20776(CommandContext<class_2168> context, String name) {
        String input = StringArgumentType.getString(context, (String)name);
        this.set(input, true, false, true);
    }

    protected void method_20777(String value) {
        this.set(value, false, true, true);
    }

    public String method_20779() {
        return this.get();
    }

    public int method_20781() {
        return this.get().length();
    }

    protected StringRule getThis() {
        return this;
    }

    public StringRule copy() {
        return new StringRule((class_1928.class_4314<StringRule>)this.field_19417, this.getMaxLength(), this.get(), this.validator, this.adapter);
    }

    public void setValue(StringRule rule, @Nullable MinecraftServer server) {
        this.bump(rule.get(), server, false);
    }

    @Override
    public IGameruleValidator<String> unruled_getValidator() {
        return this.validator;
    }

    @Override
    public void unruled_setValidator(IGameruleValidator<String> validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    @Override
    public IGameruleAdapter<String> unruled_getAdapter() {
        return this.adapter;
    }

    @Override
    public void unruled_setAdapter(IGameruleAdapter<String> adapter) {
        this.adapter = Objects.requireNonNull(adapter);
    }

    public static class Builder
    extends RuleBuilder<StringRule, String> {
        private int maxLength;

        public Builder(String initialValue, int maxLength) throws UnsupportedOperationException {
            super(StringArgumentType::string, Builder::acceptor, StringRule.class, initialValue);
            if (maxLength <= 0) {
                throw new UnsupportedOperationException("String rule size cannot be negative or null");
            }
            if (maxLength > 128) {
                throw new UnsupportedOperationException("String rule size cannot be greater than 128. Use a Text rule for that.");
            }
            Builder.checkMaxLength(maxLength);
            this.maxLength = maxLength;
        }

        public Builder(String initialValue) {
            this(initialValue, initialValue.length());
        }

        @Override
        @NotNull
        protected StringRule ruleBuilder(class_1928.class_4314<StringRule> type) {
            return new StringRule(type, this.maxLength, (String)this.initialValue, this.validator, this.adapter);
        }

        public Builder setMaxLength(int i) {
            Builder.checkMaxLength(i);
            this.maxLength = i;
            if (i < ((String)this.initialValue).length()) {
                this.initialValue = ((String)this.initialValue).substring(0, i);
            }
            return this;
        }

        public Builder setInitialValue(String s) {
            int i = Math.max(this.maxLength, s.length());
            this.setMaxLength((int)i).initialValue = s;
            return this;
        }

        static void checkMaxLength(int i) {
            if (i < 1) {
                throw new UnsupportedOperationException("String rule size cannot be negative or null");
            }
            if (i > 128) {
                throw new UnsupportedOperationException("String rule size cannot be greater than 128. Use a Text rule for that.");
            }
        }

        static void acceptor(class_1928.class_4311 consumer, class_1928.class_4313<StringRule> key, class_1928.class_4314<StringRule> type) {
            ((IGameRulesVisitor)consumer).unruled_visitString(key, type);
        }
    }
}

