package mc.recraftors.unruled_api.impl;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import mc.recraftors.unruled_api.utils.SimpleRegistryWrapperImpl;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.registry.*;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class FullRegistryWrapperLookup implements class_7225.class_7874 {
    private final Map<class_5321<? extends class_2378<?>>, class_7225<?>> map;

    public FullRegistryWrapperLookup() {
        map = Stream.concat(
                class_7923.field_41167.method_29722().stream()
                        .map(e -> new ObjectObjectImmutablePair<>(e.getKey(), e.getValue().method_46771())),
                Stream.of(new ObjectObjectImmutablePair<>(class_7923.field_41167.method_30517(), class_7923.field_41167.method_46771()))
        ).collect(Collectors.toMap(Pair::left, Pair::right, (i1, i2) -> i2));
    }

    public FullRegistryWrapperLookup(class_7157 registryAccess) {
        map = Stream.concat(
                class_7923.field_41167.method_29722().stream()
                        .flatMap(e -> Stream.of(
                                new ObjectObjectImmutablePair<>(e.getKey(), e.getValue().method_46771()),
                                new ObjectObjectImmutablePair<>(e.getKey(), (class_7225.class_7226<?>) registryAccess.method_46762(e.getKey()))
                        )),
                Stream.of(new ObjectObjectImmutablePair<>(class_7923.field_41167.method_30517(), class_7923.field_41167.method_46771()))
        ).collect(Collectors.toMap(Pair::left, Pair::right, (i1, i2) -> i2));
    }

    @Override
    public Stream<class_5321<? extends class_2378<?>>> method_55282() {
        return map.keySet().stream();
    }

    @Override
    public <T> Optional<class_7225.class_7226<T>> method_46759(class_5321<? extends class_2378<? extends T>> key) {
        //noinspection unchecked
        return Optional.ofNullable(map.getOrDefault(key, null))
                .map(w -> new SimpleRegistryWrapperImpl<>((class_7225<? super T>) w, key))
                .map(w -> (class_7225.class_7226<T>) w);

    }

    public class_7157 toCommandRegAccessAccess() {
        return new class_7157() {
            @Override
            public Stream<class_5321<? extends class_2378<?>>> method_55282() {
                return FullRegistryWrapperLookup.this.method_55282();
            }

            @Override
            public <T> Optional<class_7225.class_7226<T>> method_46759(class_5321<? extends class_2378<? extends T>> registryRef) {
                return FullRegistryWrapperLookup.this.method_46759(registryRef);
            }
        };
    }
}
