package mc.recraftors.unruled_api.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import mc.recraftors.unruled_api.rules.OverridesManager;
import mc.recraftors.unruled_api.utils.*;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_3065;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import static net.minecraft.class_2170.method_9247;

@Mixin(class_3065.class)
public abstract class GameRuleCommandMixin {
    @Inject(method = "register",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/world/GameRules;accept(Lnet/minecraft/world/GameRules$Visitor;)V"
            ))
    private static void setupOverridesCommand(
            CommandDispatcher<class_2168> dispatcher, CallbackInfo ci,
            @Local(ordinal = 0) LiteralArgumentBuilder<class_2168> literalArgumentBuilder,
            @Share("gamerule-overrides") LocalRef<LiteralArgumentBuilder<class_2168>> ref
    ) {
		LiteralArgumentBuilder<class_2168> builder = method_9247("gamerule-override")
			.requires(source -> source.method_9259(2));
        ref.set(builder);
        Utils.aggregatorsMap.set(new HashMap<>());
        builder.executes(GameRuleCommandMixin::unruled_listOverridesSimple);
        builder.then(class_2170.method_9244("dimension", class_2181.method_9288())
                .executes(GameRuleCommandMixin::unruled_listOverridesInWorld));
    }

    @WrapOperation(method = "register",
            at = @At(value = "INVOKE",
                    target = "Lcom/mojang/brigadier/CommandDispatcher;register(Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;)Lcom/mojang/brigadier/tree/LiteralCommandNode;"
            ))
    private static LiteralCommandNode<class_2168> finallizeOverridesCommand(
            CommandDispatcher<class_2168> dispatcher,
            LiteralArgumentBuilder<class_2168> command,
            Operation<LiteralCommandNode<class_2168>> original,
            @Local(ordinal = 0) LiteralArgumentBuilder<class_2168> literalArgumentBuilder,
            @Share("gamerule-overrides") LocalRef<LiteralArgumentBuilder<class_2168>> ref
    ) {
        LiteralArgumentBuilder<class_2168> builder = ref.get();
        Map<String, CommandAggregator> map = Utils.aggregatorsMap.get();
        LiteralArgumentBuilder<class_2168> get = method_9247("get");
        LiteralArgumentBuilder<class_2168> set = method_9247("set");
        LiteralArgumentBuilder<class_2168> unset = method_9247("unset");
        LiteralArgumentBuilder<class_2168> inGet = method_9247("get");
        LiteralArgumentBuilder<class_2168> inSet = method_9247("set");
        LiteralArgumentBuilder<class_2168> inUnset = method_9247("unset");
        if (map.containsKey("get")) map.get("get").aggregate(get);
        if (map.containsKey("set")) map.get("set").aggregate(set);
        if (map.containsKey("unset")) map.get("unset").aggregate(unset);
        if (map.containsKey("in-get")) map.get("in-get").aggregate(inGet);
        if (map.containsKey("in-set")) map.get("in-set").aggregate(inSet);
        if (map.containsKey("in-unset")) map.get("in-unset").aggregate(inUnset);
        for (class_1928.class_5198 c : class_1928.class_5198.values()) {
            String k = c.name();
            if (map.containsKey(k)) literalArgumentBuilder.then(map.get(k).aggregate(method_9247(k)));
            if (map.containsKey("get-"+k)) get.then(map.get("get-"+k).aggregate(method_9247(k)));
            if (map.containsKey("set-"+k)) set.then(map.get("set-"+k).aggregate(method_9247(k)));
            if (map.containsKey("unset-"+k)) unset.then(map.get("unset-"+k).aggregate(method_9247(k)));
            if (map.containsKey("in-get-"+k)) inGet.then(map.get("in-get-"+k).aggregate(method_9247(k)));
            if (map.containsKey("in-set-"+k)) inSet.then(map.get("in-set-"+k).aggregate(method_9247(k)));
            if (map.containsKey("in-unset-"+k)) inUnset.then(map.get("in-unset-"+k).aggregate(method_9247(k)));
        }
        dispatcher.register(builder.then(get).then(set).then(unset).then(
                method_9247("in").then(class_2170.method_9244("dimension", class_2181.method_9288())
                        .then(inGet).then(inSet).then(inUnset)
                )
        ));
        Utils.aggregatorsMap.remove();
        return original.call(dispatcher, command);
    }

    @WrapOperation(
            method = "executeSet",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/GameRules$Rule;set(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)V"
            )
    )
    private static void executeSetGameRuleSetWrapper(
            class_1928.class_4315<?> instance, CommandContext<class_2168> context, String name,
            Operation<Void> original
    ) throws Exception {
        try {
            original.call(instance, context, name);
        } catch (EncapsulatedException ex) {
            throw ex.exception;
        }
    }

    @Unique
    private static int unruled_listOverridesSimple(CommandContext<class_2168> context) {
        return unruled_listOverrides(context, context.getSource().method_9225());
    }

    @Unique
    private static int unruled_listOverridesInWorld(CommandContext<class_2168> context) throws CommandSyntaxException {
        return unruled_listOverrides(context, class_2181.method_9289(context, "dimension"));
    }

    @Unique
    private static int unruled_listOverrides(
            CommandContext<class_2168> context, class_3218 world
    ) {
        OverridesManager overrides = ((IGameruleOverridesProvider)world).unruled_getOverridesManager();
        Set<class_1928.class_4313<?>> set = overrides.getOverrides().getOverrides();
        StringBuilder sb = new StringBuilder();
        set.forEach(k -> sb.append("\n - ").append(k.method_20771()).append(": ").append(overrides.get(k).method_20779()));
        context.getSource().method_9226(() -> class_2561.method_48322(
                "commands.gamerule_override.list",
                LangFallbacks.OVERRIDE_LIST.format(world.method_27983().method_29177(), set.size(), sb.toString()),
                world.method_27983(), set.size(), sb.toString()), false);
        return set.size();
    }
}
