package mc.recraftors.unruled_api.mixin;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mc.recraftors.unruled_api.rules.OverridesManager;
import mc.recraftors.unruled_api.utils.*;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import java.util.function.Function;

import static net.minecraft.class_2170.method_9247;

@Mixin(targets = "net/minecraft/server/command/GameRuleCommand$1")
public abstract class GameruleCommandVisitorMixin {

    @Shadow @Final LiteralArgumentBuilder<class_2168> field_19419;

    @Inject(method = "visit", at = @At("TAIL"))
    private <T extends class_1928.class_4315<T>> void setupOverridesSubArgs(
            class_1928.class_4313<T> key, class_1928.class_4314<T> type, CallbackInfo ci
    ) {
        String k = key.method_27335().name();
        Map<String, CommandAggregator> map = Utils.aggregatorsMap.get();
        if (map == null) {
            return;
        }

        Function<String, CommandAggregator> builder = s -> new CommandAggregator();

        // gamerule <category> <rule> [<value>]
        map.computeIfAbsent(k, builder).add(method_9247(key.method_20771())
                .executes(context -> GameruleCommandInvoker.callExecuteQuery(context.getSource(), key))
                .then(type.method_20775("value")
                        .executes(context -> GameruleCommandInvoker.callExecuteSet(context, key))));

        // skip command argument creation for server-bound rules
        if (((ServerBoundAccessor)type).unruled_isServerBound()) return;

        // gamerule-override get [<category>] <rule>
        LiteralArgumentBuilder<class_2168> get = method_9247(key.method_20771())
                .executes(c -> unruled_queryOverrideSimple(c, key));
        map.computeIfAbsent("get", builder).add(get);
        map.computeIfAbsent("get-"+ k, builder).add(get);
        // gamerule-override set [<category>] <rule> <value>
        LiteralArgumentBuilder<class_2168> set = method_9247(key.method_20771()).then(type.method_20775("value")
                .executes(c -> unruled_setOverrideSimple(c, key)));
        map.computeIfAbsent("set", builder).add(set);
        map.computeIfAbsent("set-"+k, builder).add(set);
        // gamerule-override unset [<category>] <rule>
        LiteralArgumentBuilder<class_2168> unset = method_9247(key.method_20771())
                .executes(c -> unruled_unsetOverrideSimple(c, key));
        map.computeIfAbsent("unset", builder).add(unset);
        map.computeIfAbsent("unset-"+k, builder).add(unset);

        // gamerule-override in <world> get [<category>] <rule>
        LiteralArgumentBuilder<class_2168> inGet = method_9247(key.method_20771())
                .executes(c -> unruled_queryOverrideInWorld(c, key));
        map.computeIfAbsent("in-get", builder).add(inGet);
        map.computeIfAbsent("in-get-"+k, builder).add(inGet);
        // gamerule-override in <world> set [<category>] <rule> <value>
        LiteralArgumentBuilder<class_2168> inSet = method_9247(key.method_20771()).then(type.method_20775("value")
                .executes(c -> unruled_setOverrideInWorld(c, key)));
        map.computeIfAbsent("in-set", builder).add(inSet);
        map.computeIfAbsent("in-set-"+k, builder).add(inSet);
        // gamerule-override in <world> unset [<category>] <rule>
        LiteralArgumentBuilder<class_2168> inUnset = method_9247(key.method_20771())
                .executes(c -> unruled_unsetOverrideInWorld(c, key));
        map.computeIfAbsent("in-unset", builder).add(inUnset);
        map.computeIfAbsent("in-unset-"+k, builder).add(inUnset);
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_queryOverrideSimple(
            CommandContext<class_2168> context, class_1928.class_4313<T> key
    ) {
        class_3218 world = context.getSource().method_9225();
        return unruled_queryOverride(context, key, world);
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_queryOverrideInWorld(
            CommandContext<class_2168> context, class_1928.class_4313<T> key
    ) throws CommandSyntaxException {
        return unruled_queryOverride(context, key, class_2181.method_9289(context, "dimension"));
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_setOverrideSimple(
            CommandContext<class_2168> context, class_1928.class_4313<T> key
    ) {
        class_3218 world = context.getSource().method_9225();
        return unruled_setOverride(context, key, world);
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_setOverrideInWorld(
            CommandContext<class_2168> context, class_1928.class_4313<T> key
    ) throws CommandSyntaxException {
        return unruled_setOverride(context, key, class_2181.method_9289(context, "dimension"));
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_unsetOverrideSimple(
            CommandContext<class_2168> context, class_1928.class_4313<T> key
    ) {
        class_3218 world = context.getSource().method_9225();
        return unruled_unsetOverride(context, key, world);
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_unsetOverrideInWorld(
            CommandContext<class_2168> context, class_1928.class_4313<T> key
    ) throws CommandSyntaxException {
        return unruled_unsetOverride(context, key, class_2181.method_9289(context, "dimension"));
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_queryOverride(
            CommandContext<class_2168> context, class_1928.class_4313<T> key, class_3218 world
    ) {
        OverridesManager manager = ((IGameruleOverridesProvider)world).unruled_getOverridesManager();
        String keyName = key.method_20771();
        class_2960 worldId = world.method_27983().method_29177();
        if (!manager.hasOverride(key)) {
            context.getSource().method_9226(() -> class_2561.method_48322(
                    "commands.gamerule_override.none",
                    LangFallbacks.OVERRIDE_NONE.format(keyName, worldId),
                    keyName, worldId.toString()), false);
            return 0;
        }
        T rule = manager.get(key);
        context.getSource().method_9226(() -> class_2561.method_48322(
                "commands.gamerule_override.query",
                LangFallbacks.OVERRIDE_QUERY.format(keyName, worldId, rule.toString()),
                keyName, worldId.toString(), rule.toString()), false);
        return rule.method_20781();
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_setOverride(
            CommandContext<class_2168> context, class_1928.class_4313<T> key, class_3218 world
    ) {
        OverridesManager manager = ((IGameruleOverridesProvider)world).unruled_getOverridesManager();
        String keyName = key.method_20771();
        class_2960 worldId = world.method_27983().method_29177();
        boolean b = manager.override(key, context);
        if (!b) {
            context.getSource().method_9226(() -> class_2561.method_48322(
                    "commands.gamerule_override.server_bound",
                    LangFallbacks.OVERRIDE_SB.format(keyName), keyName), false);
            return context.getSource().method_9211().method_3767().method_20746(key).method_20781();
        }
        T rule = manager.get(key);
        context.getSource().method_9226(() -> class_2561.method_48322(
                "commands.gamerule_override.set",
                LangFallbacks.OVERRIDE_SET.format(keyName, worldId, rule.toString()),
                keyName, worldId.toString(), rule.toString()), true);
        return rule.method_20781();
    }

    @Unique
    private static <T extends class_1928.class_4315<T>> int unruled_unsetOverride(
            CommandContext<class_2168> context, class_1928.class_4313<T> key, class_3218 world
    ) {
        OverridesManager manager = ((IGameruleOverridesProvider)world).unruled_getOverridesManager();
        String keyName = key.method_20771();
        class_2960 worldId = world.method_27983().method_29177();
        boolean b = manager.removeOverride(key);
        String tr = "command.gamerule_override." + (b ? "unset" : "none");
        LangFallbacks fb = b ? LangFallbacks.OVERRIDE_UNSET : LangFallbacks.OVERRIDE_NONE;
        T rule = manager.get(key);
        context.getSource().method_9226(() -> class_2561.method_48322(
                tr, fb.format(keyName, worldId), keyName, worldId), true);
        return rule.method_20781();
    }
}
