package mc.recraftors.unruled_api.mixin;

import mc.recraftors.unruled_api.rules.GameRulesOverrides;
import mc.recraftors.unruled_api.rules.OverridesManager;
import mc.recraftors.unruled_api.utils.IGameruleOverridesProvider;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_26;
import net.minecraft.class_2874;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_3949;
import net.minecraft.class_5268;
import net.minecraft.class_5269;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_8565;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@Mixin(class_3218.class)
public abstract class ServerWorldMixin extends class_1937 implements IGameruleOverridesProvider {
    protected ServerWorldMixin(class_5269 properties, class_5321<class_1937> registryRef, class_5455 registryManager, class_6880<class_2874> dimensionEntry, Supplier<class_3695> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }

    @Shadow public abstract class_26 getPersistentStateManager();

    @Unique private OverridesManager gamerulesOverrides;

    @SuppressWarnings("brittleShift")
    @Inject(
            method = "<init>",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/PersistentStateManager;getOrCreate(Lnet/minecraft/world/PersistentState$Type;Ljava/lang/String;)Lnet/minecraft/world/PersistentState;",
                    shift = At.Shift.AFTER
            )
    )
    private void unruled_initGamerulesOverridesManager(
            MinecraftServer server, Executor workerExecutor, class_32.class_5143 session,
            class_5268 properties, class_5321<class_1937> worldKey, class_5363 dimensionOptions,
            class_3949 worldGenerationProgressListener, boolean debugWorld, long seed,
            List<class_5304> spawners, boolean shouldTickTime, class_8565 random, CallbackInfo ci
    ) {
        class_1928 rules = properties.method_146();
        this.gamerulesOverrides = this.getPersistentStateManager().method_17924(
                OverridesManager.getPersistentStateType(rules), "gamerules"
        );
    }

    @Override
    public class_1928 method_8450() {
        if (this.gamerulesOverrides.isEmpty()) return super.method_8450();
        return this.unruled_getOverridesManager().getOverrides();
    }

    @Override
    public OverridesManager unruled_getOverridesManager() {
        return this.gamerulesOverrides;
    }
}
