package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import mc.recraftors.unruled_api.UnruledApi;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameRulesVisitor;
import mc.recraftors.unruled_api.utils.IGameruleAdapter;
import mc.recraftors.unruled_api.utils.IGameruleValidator;
import net.minecraft.class_1928.class_4311;
import net.minecraft.class_1928.class_4313;
import net.minecraft.class_1928.class_4314;
import net.minecraft.class_1928.class_4315;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameRules.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.Optional;

@SuppressWarnings("unused")
public class DoubleRule extends class_4315<DoubleRule> implements GameruleAccessor<Double> {
    private double value;
    private IGameruleValidator<Double> validator;
    private IGameruleAdapter<Double> adapter;

    public DoubleRule(class_4314<DoubleRule> type, double initialValue, IGameruleValidator<Double> validator, IGameruleAdapter<Double> adapter) {
        super(type);
        Objects.requireNonNull(validator);
        Objects.requireNonNull(adapter);
        this.value = initialValue;
        this.validator = validator;
        this.adapter = adapter;
    }

    public DoubleRule(class_4314<DoubleRule> type, double initialValue) {
        this(type, initialValue, IGameruleValidator::alwaysTrue, Optional::of);
    }

    public double get() {
        return this.value;
    }

    public void set(double value, MinecraftServer server) {
        if (this.validator.validate(value)) {
            this.value = value;
            this.method_20778(server);
            return;
        }
        Optional<Double> o = this.adapter.adapt(value);
        if (o.isPresent() && this.validator.validate(o.get())) {
            this.value = o.get();
            this.method_20778(server);
        }
    }

    public boolean validate(String input) {
        try {
            double d = Double.parseDouble(input);
            if (this.validator.validate(d)) {
                this.value = d;
                return true;
            }
            return false;
        } catch (NumberFormatException e) {
            return false;
        }
    }

    private static double parseDouble(String input) {
        if (!input.isEmpty()) {
            try {
                return Double.parseDouble(input);
            } catch (NumberFormatException e) {
                UnruledApi.LOGGER.warn("Failed to parse double from '{}'", input);
            }
        }
        return 0;
    }

    @Override
    protected void method_20776(CommandContext<class_2168> context, String name) {
        double d = DoubleArgumentType.getDouble(context, name);
        boolean b = this.validator.validate(d);
        if (b) {
            this.value = d;
            return;
        }
        Optional<Double> o = this.adapter.adapt(d);
        if (o.isPresent()) {
            b = this.validator.validate(o.get());
            if (b) {
                this.value = o.get();
                return;
            }
        }
        throw new IllegalArgumentException("Invalid value "+d);
    }

    @Override
    protected void method_20777(String value) {
        double d = parseDouble(value);
        boolean b = this.validator.validate(d);
        if (b) {
            this.value = d;
            return;
        }
        Optional<Double> o = this.adapter.adapt(d);
        if (o.isPresent()) {
            b = this.validator.validate(o.get());
            if (b) {
                this.value = o.get();
            }
        }
    }

    @Override
    public String method_20779() {
        return Double.toString(this.value);
    }

    @Override
    public int method_20781() {
        return (int) this.value;
    }

    @Override
    protected DoubleRule method_20782() {
        return this;
    }

    @Override
    public DoubleRule method_27338() {
        return new DoubleRule(this.field_19417, this.value, this.validator, this.adapter);
    }

    @Override
    public void setValue(DoubleRule rule, @Nullable MinecraftServer server) {
        double d = rule.get();
        boolean b = this.validator.validate(d);
        if (!b) {
            Optional<Double> o = this.adapter.adapt(d);
            if (o.isPresent() && this.validator.validate(o.get())) {
                d = o.get();
                b = true;
            }
        }
        if (b) {
            this.value = d;
            this.method_20778(server);
        }
    }

    @Override
    public IGameruleValidator<Double> unruled_getValidator() {
        return this.validator;
    }

    @Override
    public void unruled_setValidator(IGameruleValidator<Double> validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    @Override
    public IGameruleAdapter<Double> unruled_getAdapter() {
        return this.adapter;
    }

    @Override
    public void unruled_setAdapter(IGameruleAdapter<Double> adapter) {
        this.adapter = Objects.requireNonNull(adapter);
    }

    public static class Builder extends RuleBuilder<DoubleRule, Double> {
        public Builder(double initialValue) {
            super(DoubleArgumentType::doubleArg, Builder::acceptor, initialValue);
        }

        @Override
        @NotNull
        protected DoubleRule ruleBuilder(class_4314<DoubleRule> type) {
            return new DoubleRule(type, super.initialValue, super.validator, super.adapter);
        }

        static void acceptor(class_4311 consumer, class_4313<DoubleRule> key, class_4314<DoubleRule> type) {
            ((IGameRulesVisitor)consumer).unruled_visitDouble(key, type);
        }
    }
}
