/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mc.recraftors.unruled_api.impl.GameruleValidatorAdapter;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameruleAdapter;
import mc.recraftors.unruled_api.utils.IGameruleValidator;
import mc.recraftors.unruled_api.utils.ServerBoundAccessor;
import net.minecraft.class_1928;
import net.minecraft.class_7699;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public abstract class RuleBuilder<T extends class_1928.class_4315<T>, V> {
    protected final Supplier<ArgumentType<?>> argumentSupplier;
    protected final class_1928.class_5199<T> screenVisitor;
    protected V initialValue;
    protected BiConsumer<MinecraftServer, T> changeCallback;
    protected IGameruleValidator<V> validator;
    protected IGameruleAdapter<V> adapter;
    protected class_7699 featureSet;
    protected boolean serverBound;

    protected RuleBuilder(Supplier<ArgumentType<?>> argumentSupplier, class_1928.class_5199<T> screenVisitor, V initialValue) {
        this.argumentSupplier = Objects.requireNonNull(argumentSupplier);
        this.screenVisitor = Objects.requireNonNull(screenVisitor);
        this.initialValue = initialValue;
        this.changeCallback = (w, s) -> {};
        this.validator = IGameruleValidator::alwaysTrue;
        this.adapter = Optional::of;
        this.featureSet = class_7699.method_45397();
    }

    @NotNull
    protected abstract T ruleBuilder(class_1928.class_4314<T> var1);

    public final RuleBuilder<T, V> setChangeCallback(BiConsumer<MinecraftServer, T> changeCallback) {
        this.changeCallback = Objects.requireNonNull(changeCallback);
        return this;
    }

    public final RuleBuilder<T, V> setValidator(IGameruleValidator<V> validator) {
        this.validator = Objects.requireNonNull(validator);
        return this;
    }

    public final RuleBuilder<T, V> setAdapter(IGameruleAdapter<V> adapter) {
        this.adapter = Objects.requireNonNull(adapter);
        return this;
    }

    public final RuleBuilder<T, V> setValidatorAdapter(GameruleValidatorAdapter<V> validatorAdapter) {
        Objects.requireNonNull(validatorAdapter);
        this.validator = validatorAdapter;
        this.adapter = validatorAdapter;
        return this;
    }

    public final RuleBuilder<T, V> setFeatureSet(class_7699 featureSet) {
        this.featureSet = Objects.requireNonNull(featureSet);
        return this;
    }

    public final RuleBuilder<T, V> setServerBound(boolean serverBound) {
        this.serverBound = serverBound;
        return this;
    }

    public class_1928.class_4314<T> build() {
        class_1928.class_4314 type = new class_1928.class_4314(this.argumentSupplier, this::ruleBuilder, this.changeCallback, this.screenVisitor);
        ((ServerBoundAccessor)type).unruled_setServerBound(this.serverBound);
        return type;
    }

    public class_1928.class_4313<T> register(String name, class_1928.class_5198 category) {
        return class_1928.method_8359((String)name, (class_1928.class_5198)category, this.build());
    }

    public static class IntRuleBuilder
    extends RuleBuilder<class_1928.class_4312, Integer> {
        public IntRuleBuilder(int initialValue) {
            super(IntegerArgumentType::integer, class_1928.class_4311::method_27330, initialValue);
        }

        @Override
        @NotNull
        protected class_1928.class_4312 ruleBuilder(class_1928.class_4314<class_1928.class_4312> type) {
            class_1928.class_4312 rule = new class_1928.class_4312(type, ((Integer)this.initialValue).intValue());
            GameruleAccessor accessor = (GameruleAccessor)rule;
            accessor.unruled_setValidator(this.validator);
            accessor.unruled_setAdapter(this.adapter);
            return rule;
        }
    }
}

