package mc.recraftors.unruled_api.mixin;

import mc.recraftors.unruled_api.utils.IGamerulesInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.MinecraftClient;
import net.minecraft.resource.ResourcePackManager;
import net.minecraft.server.SaveLoader;
import net.minecraft.world.level.storage.LevelStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(MinecraftClient.class)
public abstract class MinecraftClientMixin {
    @Inject(method = "startIntegratedServer", at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/world/level/storage/LevelStorage$Session;backupLevelDataFile(Lnet/minecraft/registry/DynamicRegistryManager;Lnet/minecraft/world/SaveProperties;)V"
    ))
    private void startWorldSetupRulesRegistries(
            String levelName, LevelStorage.Session session, ResourcePackManager dataPackManager,
            SaveLoader saveLoader, boolean newWorld, CallbackInfo ci
    ) {
        ((IGamerulesInitializer)saveLoader.saveProperties().getGameRules()).unruled_loadRegistryEntries(saveLoader.combinedDynamicRegistries().getCombinedRegistryManager());
    }
}
