package mc.recraftors.unruled_api.mixin;

import mc.recraftors.unruled_api.rules.GameRulesOverrides;
import mc.recraftors.unruled_api.rules.OverridesManager;
import mc.recraftors.unruled_api.utils.IGameruleOverridesProvider;
import net.minecraft.registry.DynamicRegistryManager;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldGenerationProgressListener;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.math.random.RandomSequencesState;
import net.minecraft.util.profiler.Profiler;
import net.minecraft.world.GameRules;
import net.minecraft.world.MutableWorldProperties;
import net.minecraft.world.PersistentStateManager;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionOptions;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.level.ServerWorldProperties;
import net.minecraft.world.level.storage.LevelStorage;
import net.minecraft.world.spawner.Spawner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@Mixin(ServerWorld.class)
public abstract class ServerWorldMixin extends World implements IGameruleOverridesProvider {
    protected ServerWorldMixin(MutableWorldProperties properties, RegistryKey<World> registryRef, DynamicRegistryManager registryManager, RegistryEntry<DimensionType> dimensionEntry, Supplier<Profiler> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }

    @Shadow public abstract PersistentStateManager getPersistentStateManager();

    @Unique private OverridesManager gamerulesOverrides;

    @SuppressWarnings("brittleShift")
    @Inject(
            method = "<init>",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/PersistentStateManager;getOrCreate(Lnet/minecraft/world/PersistentState$Type;Ljava/lang/String;)Lnet/minecraft/world/PersistentState;",
                    shift = At.Shift.AFTER
            )
    )
    private void unruled_initGamerulesOverridesManager(
            MinecraftServer server, Executor workerExecutor, LevelStorage.Session session,
            ServerWorldProperties properties, RegistryKey<World> worldKey, DimensionOptions dimensionOptions,
            WorldGenerationProgressListener worldGenerationProgressListener, boolean debugWorld, long seed,
            List<Spawner> spawners, boolean shouldTickTime, RandomSequencesState randomSequencesState, CallbackInfo ci
    ) {
        GameRules rules = properties.getGameRules();
        this.gamerulesOverrides = this.getPersistentStateManager().getOrCreate(
                OverridesManager.getPersistentStateType(rules), "gamerules"
        );
    }

    @Override
    public GameRules getGameRules() {
        if (this.gamerulesOverrides.isEmpty()) return super.getGameRules();
        return this.unruled_getOverridesManager().getOverrides();
    }

    @Override
    public OverridesManager unruled_getOverridesManager() {
        return this.gamerulesOverrides;
    }
}
