package mc.recraftors.unruled_api.utils;

import mc.recraftors.unruled_api.rules.*;
import net.minecraft.command.EntitySelector;
import net.minecraft.world.GameRules;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * Utility interface for floating gamerules handling.
 */
@SuppressWarnings("unused")
public interface IGameRulesProvider {
    default float unruled_getFloat(GameRules.Key<FloatRule> key) {
        return 0;
    }

    default long unruled_getLong(GameRules.Key<LongRule> key) {
        return 0;
    }

    default double unruled_getDouble(GameRules.Key<DoubleRule> key) {
        return 0;
    }

    default <T extends Enum<T>> T unruled_getEnum(GameRules.Key<EnumRule<T>> key) {
        return null;
    }

    default String unruled_getString(GameRules.Key<StringRule> key) {
        return null;
    }

    default EntitySelector unruled_getEntitySelector(GameRules.Key<EntitySelectorRule> key) {
        return null;
    }

    default <T> T unruled_getRegistryEntry(GameRules.Key<RegistryEntryRule<T>> key) {
        return null;
    }

    default String unruled_getText(GameRules.Key<TextRule> key) {
        return null;
    }

    default Map<String, GameRules.Key<?>> unruled_getMatchingRules(Set<String> names) {
        return new HashMap<>();
    }
}
