package mc.recraftors.unruled_api.utils;

import com.mojang.serialization.Lifecycle;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryWrapper;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.registry.entry.RegistryEntryList;
import net.minecraft.registry.tag.TagKey;

import java.util.Optional;
import java.util.stream.Stream;

public class SimpleRegistryWrapperImpl <T> implements RegistryWrapper.Impl<T> {
    private final RegistryWrapper<T> base;
    private final RegistryKey<? extends Registry<? extends T>> key;

    public SimpleRegistryWrapperImpl(RegistryWrapper<T> base, RegistryKey<? extends Registry<? extends T>> key) {
        this.base = base;
        this.key = key;
    }

    @Override
    public RegistryKey<? extends Registry<? extends T>> getRegistryKey() {
        return this.key;
    }

    @Override
    public Lifecycle getLifecycle() {
        return Lifecycle.stable(); // fallback I guess
    }

    @Override
    public Stream<RegistryEntry.Reference<T>> streamEntries() {
        return base.streamEntries();
    }

    @Override
    public Stream<RegistryEntryList.Named<T>> streamTags() {
        return base.streamTags();
    }

    @Override
    public Optional<RegistryEntry.Reference<T>> getOptional(RegistryKey<T> key) {
        return base.getOptional(key);
    }

    @Override
    public Optional<RegistryEntryList.Named<T>> getOptional(TagKey<T> tag) {
        return base.getOptional(tag);
    }
}
