package mc.recraftors.unruled_api.impl;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import mc.recraftors.unruled_api.utils.SimpleRegistryWrapperImpl;
import net.minecraft.command.CommandRegistryAccess;
import net.minecraft.registry.*;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class FullRegistryWrapperLookup implements RegistryWrapper.WrapperLookup {
    private final Map<RegistryKey<? extends Registry<?>>, RegistryWrapper<?>> map;

    public FullRegistryWrapperLookup() {
        map = Stream.concat(
                Registries.REGISTRIES.getEntrySet().stream()
                        .map(e -> new ObjectObjectImmutablePair<>(e.getKey(), e.getValue().getReadOnlyWrapper())),
                Stream.of(new ObjectObjectImmutablePair<>(Registries.REGISTRIES.getKey(), Registries.REGISTRIES.getReadOnlyWrapper()))
        ).collect(Collectors.toMap(Pair::left, Pair::right, (i1, i2) -> i2));
    }

    public FullRegistryWrapperLookup(CommandRegistryAccess registryAccess) {
        map = Stream.concat(
                Registries.REGISTRIES.getEntrySet().stream()
                        .flatMap(e -> Stream.of(
                                new ObjectObjectImmutablePair<>(e.getKey(), e.getValue().getReadOnlyWrapper()),
                                new ObjectObjectImmutablePair<>(e.getKey(), (RegistryWrapper.Impl<?>) registryAccess.getWrapperOrThrow(e.getKey()))
                        )),
                Stream.of(new ObjectObjectImmutablePair<>(Registries.REGISTRIES.getKey(), Registries.REGISTRIES.getReadOnlyWrapper()))
        ).collect(Collectors.toMap(Pair::left, Pair::right, (i1, i2) -> i2));
    }

    @Override
    public Stream<RegistryKey<? extends Registry<?>>> streamAllRegistryKeys() {
        return map.keySet().stream();
    }

    @Override
    public <T> Optional<RegistryWrapper.Impl<T>> getOptionalWrapper(RegistryKey<? extends Registry<? extends T>> key) {
        //noinspection unchecked
        return Optional.ofNullable(map.getOrDefault(key, null))
                .map(w -> new SimpleRegistryWrapperImpl<>((RegistryWrapper<? super T>) w, key))
                .map(w -> (RegistryWrapper.Impl<T>) w);

    }

    public CommandRegistryAccess toCommandRegAccessAccess() {
        return new CommandRegistryAccess() {
            @Override
            public Stream<RegistryKey<? extends Registry<?>>> streamAllRegistryKeys() {
                return FullRegistryWrapperLookup.this.streamAllRegistryKeys();
            }

            @Override
            public <T> Optional<RegistryWrapper.Impl<T>> getOptionalWrapper(RegistryKey<? extends Registry<? extends T>> registryRef) {
                return FullRegistryWrapperLookup.this.getOptionalWrapper(registryRef);
            }
        };
    }
}
