package mc.recraftors.unruled_api.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import mc.recraftors.unruled_api.utils.EnumArgSupplier;
import mc.recraftors.unruled_api.rules.EnumRule;
import mc.recraftors.unruled_api.utils.RegArgBuilder;
import mc.recraftors.unruled_api.utils.Utils;
import net.minecraft.command.CommandSource;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.world.GameRules;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.function.Supplier;

@Mixin(GameRules.Type.class)
public abstract class GameRulesTypeMixin {
    @Shadow @Final private Supplier<ArgumentType<?>> argumentType;

    @Inject(method = "argument", at = @At("RETURN"))
    private void onArgumentHeadSpecialArgHandler(
            String name, CallbackInfoReturnable<RequiredArgumentBuilder<ServerCommandSource, ?>> cir) {
        if (this.argumentType instanceof EnumArgSupplier<?> supplier) {
            cir.getReturnValue().suggests((context, builder) ->
                    CommandSource.suggestMatching(EnumRule.getEnumNames(supplier.unruled_getTargetClass()), builder));
        }
    }

    @WrapOperation(method = "argument", at = @At(value = "INVOKE", target = "Ljava/util/function/Supplier;get()Ljava/lang/Object;"))
    private <T> T unruled_applyRegRuleAccess(Supplier<T> instance, Operation<T> original) {
        if (instance instanceof RegArgBuilder<?> builder) {
            // noinspection unchecked
            return (T) builder.build(Utils.registryAccessThreadLocal.get());
        }
        return original.call(instance);
    }
}
