package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.context.CommandContext;
import mc.recraftors.unruled_api.UnruledApi;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameRulesProvider;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.world.GameRules;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class GameRulesOverrides extends GameRules {
    private final GameRules base;
    private final Map<GameRules.Key<?>, GameRules.Rule<?>> overrides;

    public GameRulesOverrides(GameRules base, Map<String, String> map) {
        super();
        this.base = base;
        this.overrides = new HashMap<>();
        Map<String, Key<?>> keyMap = ((IGameRulesProvider) base).unruled_getMatchingRules(map.keySet());
        keyMap.forEach((k, v) -> {
            String s = map.get(k);
            try {
                this.overrides.put(v, ((GameruleAccessor<?>) base.get(v).copy()).unruled_setValue(s));
            } catch (Exception ex) {
                UnruledApi.LOGGER.warn("Unable to deserialize override for {} from {}", k, s);
            }
        });
    }

    public boolean isEmpty() {
        return this.overrides.isEmpty();
    }

    public <T extends Rule<T>> boolean hasOverride(Key<T> key) {
        return this.overrides.containsKey(key);
    }

    public <T extends Rule<T>> void override(Key<T> key, CommandContext<ServerCommandSource> context) {
        if (!this.overrides.containsKey(key)) this.overrides.put(key, this.base.get(key).copy());
        this.overrides.get(key).set(context, "value");
    }

    public <T extends Rule<T>> boolean removeOverride(Key<T> key) {
        if (this.hasOverride(key)) {
            this.overrides.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public <T extends Rule<T>> T get(Key<T> key) {
        //noinspection unchecked
        return Optional.ofNullable((T) this.overrides.get(key))
                .orElseGet(() -> this.base.get(key));
    }

    public Set<GameRules.Key<?>> getOverrides() {
        return this.overrides.keySet();
    }
}
