package mc.recraftors.unruled_api.utils;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.MinecraftClient;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.world.World;

@Environment(EnvType.CLIENT)
public final class ClientUtils {
    public static <T> Registry<T> getClientWorldRegistryOrThrow(RegistryKey<? extends Registry<T>> key) {
        World world = MinecraftClient.getInstance().world;
        if (world == null) throw new UnsupportedOperationException("No loaded world");
        return world.getRegistryManager().get(key);
    }
}
